var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Set subsystem for subtasks when subsystem is set in parent task'),
  guard: function(ctx) {
    return ctx.issue.fields.isChanged(ctx.Subsystem) && ctx.issue.fields.Subsystem;
  },
  action: function(ctx) {
    var issue = ctx.issue;

    var safeSetSubsystem = function(subtask) {
      if (subtask.project && subtask.isReported && !subtask.project.isArchived) {
        if (subtask.project.key === issue.project.key || subtask.project.findFieldByName(ctx.Subsystem.name)) {
          if ((issue.fields.oldValue(ctx.Subsystem) || {}).name === (subtask.fields.Subsystem || {}).name) {
            var value = subtask.project.findFieldByName(ctx.Subsystem.name).findValueByName(issue.fields.Subsystem.name);
            if (value) {
              subtask.fields.Subsystem = value;
            }
          }
        }
      }
    };

    issue.links["parent for"].forEach(safeSetSubsystem);
  },
  requirements: {
    Subsystem: {
      type: entities.EnumField.fieldType
    },
    SubtaskOf: {
      type: entities.IssueLinkPrototype,
      name: 'Subtask',
      outward: 'parent for',
      inward: 'subtask of'
    }
  }
});