var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Open parent task when subtask changes to an unresolved state'),
  guard: function(ctx) {
    return ctx.issue.isReported && ctx.issue.becomesUnresolved;
  },
  action: function (ctx) {
    var processParent = function(issue) {
      if (issue.links['subtask of'].isEmpty()) {
        return;
      }
      var parent = issue.links['subtask of'].first();
      if (parent && parent.project && !parent.project.isArchived && parent.isReported && parent.isResolved) {
        var field = parent.project.findFieldByName(ctx.State.name);
        if (field) {
          var value = field.findValueByName(ctx.State.Open.name);
          if (value) {
            parent.State = value;
            workflow.message(workflow.i18n('Automatically reopen {0}', parent.id));
            return parent;
          }
        }
      }
    };

    var issue = ctx.issue;
    while (issue) {
      issue = processParent(issue);
    }
  },
  requirements: {
    State: {
      type: entities.State.fieldType,
      Open: {}
    }
  }
});