var entities = require('@jetbrains/youtrack-scripting-api/entities');

exports.rule = entities.Issue.onChange({
  title: 'Clear fixed in build when issue changes to an unresolved state',
  guard: function(ctx) {
    return ctx.issue.isReported && ctx.issue.becomesUnresolved;
  },
  action: function(ctx) {
    ctx.issue.fields.FixedInBuild = null;
  },
  requirements: {
    FixedInBuild: {
      name: 'Fixed in build',
      type: entities.Build.fieldType
    }
  }
});