var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Copy fixed in build to duplicate issues '),
  guard: function(ctx) {
    return ctx.issue.fields.becomes(ctx.State, ctx.State.Duplicate);
  },
  action: function(ctx) {
    var issue = ctx.issue;
    issue.links.duplicates.forEach(function(duplicate) {
      if (duplicate.project.name === issue.project.name && duplicate.fields[ctx.FixedInBuild.name]) {
        issue.fields.FixedInBuild = duplicate.fields[ctx.FixedInBuild.name];
      }
    });
  },
  requirements: {
    FixedInBuild: {
      name: 'Fixed in build',
      type: entities.Build.fieldType
    },
    State: {
      type: entities.State.fieldType,
      Duplicate: {}
    }
  }
});