var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Set fixed in build to "Never" when state changes to "Won\'t fix" '),
  guard: function(ctx) {
    return ctx.issue.fields.becomes(ctx.State, ctx.State.WontFix);
  },
  action: function(ctx) {
    ctx.issue.fields.FixedInBuild = ctx.FixedInBuild.Never;
  },
  requirements: {
    State: {
      type: entities.State.fieldType,
      WontFix: {
        name: 'Won\'t fix'
      }
    },
    FixedInBuild: {
      type: entities.Build.fieldType,
      name: 'Fixed in build',
      Never: {}
    }
  }
});