/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.zendesk.rest.integration;

import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import jetbrains.charisma.rest.JacksonObjectMapperProvider;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.youtrack.zendesk.persistent.XdAgreement;
import jetbrains.youtrack.zendesk.persistent.XdTicketSharingInfo;
import jetbrains.youtrack.zendesk.rest.integration.NHDAgreement;
import jetbrains.youtrack.zendesk.rest.integration.NHDProtocolKt;
import jetbrains.youtrack.zendesk.rest.integration.NHDTicket;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0006\u0010\u0015\u001a\u00020\fJ\u0016\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/youtrack/zendesk/rest/integration/NHDRest;", "", "agreement", "Ljetbrains/youtrack/zendesk/persistent/XdAgreement;", "(Ljetbrains/youtrack/zendesk/persistent/XdAgreement;)V", "agreementBuilder", "Ljavax/ws/rs/client/Invocation$Builder;", "getAgreementBuilder", "()Ljavax/ws/rs/client/Invocation$Builder;", "webResource", "Ljavax/ws/rs/client/WebTarget;", "addHeaders", "", "builder", "includeSharingToken", "", "put", "body", "errorMessage", "Lkotlin/Function0;", "", "putAgreement", "putTicket", "sharingInfo", "Ljetbrains/youtrack/zendesk/persistent/XdTicketSharingInfo;", "ignoreStatus", "Companion", "youtrack-zendesk-integration"})
public final class NHDRest {
    private final WebTarget webResource;
    private final XdAgreement agreement;
    private static final Logger LOGGER;
    public static final Companion Companion;

    private final Invocation.Builder getAgreementBuilder() {
        Invocation.Builder builder = this.webResource.path("/agreements/" + this.agreement.getUuid()).request();
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"webResource.path(\"/agree\u2026reement.uuid}\").request()");
        return builder;
    }

    public final void putAgreement() {
        this.put(this.getAgreementBuilder(), new NHDAgreement(this.agreement), (Function0<String>)((Function0)new Function0<String>(this){
            final /* synthetic */ NHDRest this$0;

            @NotNull
            public final String invoke() {
                return "can't update agreement " + NHDRest.access$getAgreement$p(this.this$0).getUuid();
            }
            {
                this.this$0 = nHDRest;
                super(0);
            }
        }));
    }

    public final void putTicket(@NotNull XdTicketSharingInfo sharingInfo2, boolean ignoreStatus) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)sharingInfo2), (String)"sharingInfo");
        Invocation.Builder builder = this.webResource.path("/tickets/" + sharingInfo2.getUuid()).request();
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"webResource.path(\"/ticke\u2026ingInfo.uuid}\").request()");
        this.put(builder, new NHDTicket(sharingInfo2, ignoreStatus), (Function0<String>)((Function0)new Function0<String>(sharingInfo2){
            final /* synthetic */ XdTicketSharingInfo $sharingInfo;

            @NotNull
            public final String invoke() {
                return "can't update ticket " + this.$sharingInfo.getUuid();
            }
            {
                this.$sharingInfo = xdTicketSharingInfo;
                super(0);
            }
        }));
    }

    private final void put(Invocation.Builder builder, Object body, Function0<String> errorMessage) {
        block4: {
            try {
                String string;
                Response response;
                this.addHeaders(builder, true);
                Response response2 = response = builder.put(Entity.json((Object)body));
                Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
                Response.StatusType statusType = response2.getStatusInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusType, (String)"response.statusInfo");
                if (statusType.getFamily() == Response.Status.Family.SUCCESSFUL) break block4;
                try {
                    string = (String)response.readEntity(String.class);
                }
                catch (Exception e) {
                    string = "unknown body";
                }
                String responseBody = string;
                String msg = (String)errorMessage.invoke() + " - receiving " + response.getStatus() + " code with: \n " + responseBody;
                Companion.getLogger().warn(msg);
                throw (Throwable)new Exception(msg);
            }
            catch (Exception e) {
                throw (Throwable)new LocalizedLogicException(e);
            }
        }
    }

    private final void addHeaders(Invocation.Builder builder, boolean includeSharingToken) {
        if (includeSharingToken) {
            builder.header(NHDProtocolKt.getTICKET_SHARING_TOKEN_HEADER(), (Object)(this.agreement.getUuid() + ":" + this.agreement.getAccessKey()));
        }
        builder.header("Content-Type", (Object)"application/json;charset=UTF-8");
    }

    public NHDRest(@NotNull XdAgreement agreement) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)agreement), (String)"agreement");
        this.agreement = agreement;
        WebTarget webTarget = NHDRest.Companion.newResource().target(this.agreement.getSenderUrl());
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"newResource().target(agreement.senderUrl)");
        this.webResource = webTarget;
    }

    static {
        Companion = new Companion(null);
        LOGGER = Logger.getLogger(NHDRest.class.getName());
    }

    @NotNull
    public static final /* synthetic */ XdAgreement access$getAgreement$p(NHDRest $this) {
        return $this.agreement;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljetbrains/youtrack/zendesk/rest/integration/NHDRest$Companion;", "Lmu/KLogging;", "()V", "LOGGER", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "newResource", "Ljavax/ws/rs/client/Client;", "youtrack-zendesk-integration"})
    public static final class Companion
    extends KLogging {
        private final Client newResource() {
            ClientBuilder clientBuilder;
            String string = System.getProperty("jetbrains.youtrack.zendesk.httpLogging");
            if (string == null) {
                string = "false";
            }
            String logReqResponse = string;
            ClientBuilder $receiver = clientBuilder = ClientBuilder.newBuilder();
            String string2 = logReqResponse;
            if (Boolean.parseBoolean(string2)) {
                $receiver.withConfig((Configuration)new ClientConfig().register((Object)new LoggingFilter(LOGGER, true)));
            }
            $receiver.register(JacksonObjectMapperProvider.class);
            $receiver.register(JacksonFeature.class);
            Client client = clientBuilder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)client, (String)"ClientBuilder.newBuilder\u2026va)\n            }.build()");
            return client;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

