/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.backend.rest;

import com.jetbrains.bundle.api.clientcert.model.ClientCertAuthSettings;
import com.jetbrains.bundle.api.exceptions.BundleBackendException;
import com.jetbrains.bundle.api.internal.backend.BundleFacade;
import com.jetbrains.bundle.client.model.CertificateAuthSettingsJSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/certificateAuth"}, produces={"application/json"})
public class ClientCertificateAuthSettingsController {
    @Autowired
    private BundleFacade myBundleFacade;

    @RequestMapping(method={RequestMethod.POST})
    public void updateCertificateAuthSettings(@RequestBody CertificateAuthSettingsJSON requestBody, @RequestParam(value="bundleBackendToken") String bundleBackendToken, @RequestParam(value="fields", required=false) String fields) throws BundleBackendException {
        if (requestBody == null) {
            throw new RuntimeException("Empty request body");
        }
        if (requestBody.isEnabled() && (requestBody.getCertBase64Der() == null || requestBody.getCertBase64Der().isEmpty())) {
            throw new RuntimeException("At least one certificate should be specified if client certificate authentication is enabled");
        }
        this.myBundleFacade.changeClientCertificateAuthSettings(requestBody.isEnabled(), requestBody.getCertBase64Der());
    }

    @RequestMapping(method={RequestMethod.GET})
    public CertificateAuthSettingsJSON getCertificateAuthSettings(@RequestParam(value="bundleBackendToken") String bundleBackendToken, @RequestParam(value="fields", required=false) String fields) throws BundleBackendException {
        ClientCertAuthSettings settings = this.myBundleFacade.getClientCertificateAuthSettings();
        return new CertificateAuthSettingsJSON(settings.isEnabled(), settings.getCertBase64Encoded());
    }
}

