/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.backend.rest;

import com.jetbrains.bundle.api.exceptions.BundleBackendException;
import com.jetbrains.bundle.api.internal.backend.BundleFacade;
import com.jetbrains.bundle.client.model.PropertyJSON;
import com.jetbrains.bundle.client.model.UpdatePropertiesRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/settings"}, produces={"application/json"})
public class PropertiesController {
    @Autowired
    private BundleFacade myBundleFacade;

    @RequestMapping(method={RequestMethod.POST})
    public void updateProperty(@RequestBody UpdatePropertiesRequest requestBody, @RequestParam(value="bundleBackendToken") String bundleBackendToken, @RequestParam(value="fields", required=false) String fields) throws BundleBackendException {
        if (requestBody == null || requestBody.getProperty() == null) {
            throw new RuntimeException("property is not passed in request body");
        }
        this.myBundleFacade.updateProperty(requestBody.getProperty().getName(), requestBody.getProperty().getValue(), requestBody.isSkipValidation());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/candidate"})
    public void validateProperty(@RequestBody PropertyJSON property, @RequestParam(value="bundleBackendToken") String bundleBackendToken, @RequestParam(value="fields", required=false) String fields) throws BundleBackendException {
        if (property == null) {
            throw new RuntimeException("property is not passed in request body");
        }
        this.myBundleFacade.validateProperty(property.getName(), property.getValue());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{propertyName}"})
    public PropertyJSON getProperty(@PathVariable(value="propertyName") String propertyName, @RequestParam(value="bundleBackendToken") String bundleBackendToken, @RequestParam(value="fields", required=false) String fields) throws BundleBackendException {
        if (propertyName == null) {
            throw new RuntimeException("propertyName is not resolved");
        }
        String value = this.myBundleFacade.getProperty(propertyName);
        return new PropertyJSON(propertyName, value);
    }
}

