/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.backend.rest;

import com.jetbrains.bundle.api.exceptions.BundleBackendException;
import com.jetbrains.bundle.api.model.ErrorInfo;
import com.jetbrains.bundle.backend.model.error.TooManyFailedAuthAttemptsResult;
import com.jetbrains.bundle.client.error.BundleBackendErrorCode;
import com.jetbrains.bundle.client.model.ErrorJSON;
import com.jetbrains.bundle.util.auth.exceptions.AuthenticationException;
import com.jetbrains.bundle.util.auth.exceptions.TooManyFailedAuthAttemptsException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class RequestErrorHandler {
    private Logger LOG = LoggerFactory.getLogger(this.getClass());

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={AuthenticationException.class})
    @ResponseBody
    public ErrorJSON handleException(AuthenticationException exception) {
        this.logExceptionCausedByAnotherException((Exception)exception);
        return BundleBackendErrorCode.INVALID_BUNDLE_BACKEND_TOKEN.toError();
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={TooManyFailedAuthAttemptsException.class})
    @ResponseBody
    public ErrorJSON handleException(TooManyFailedAuthAttemptsException exception) {
        this.logExceptionCausedByAnotherException((Exception)exception);
        return new TooManyFailedAuthAttemptsResult(BundleBackendErrorCode.BUNDLE_BACKEND_TOO_MANY_FAILED_AUTHENTICATION_ATTEMPTS.toError(), exception.getIntervalToWaitInMillis(), exception.getFailedAttemptsCount());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={BundleBackendException.class})
    @ResponseBody
    public ErrorJSON handleException(BundleBackendException exception) {
        this.logExceptionCausedByAnotherException((Exception)exception);
        return RequestErrorHandler.convert(exception.getErrorInfo());
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    public ErrorJSON handleException(RuntimeException exception) {
        this.logException(exception);
        return BundleBackendErrorCode.UNEXPECTED.toError(Collections.singletonMap("reason", exception.getMessage()));
    }

    private void logException(Exception e) {
        this.LOG.debug(e.getMessage() != null ? e.getMessage() : "", (Throwable)e);
    }

    private void logExceptionCausedByAnotherException(Exception e) {
        if (e.getCause() != null) {
            this.logException(e);
        }
    }

    private static ErrorJSON convert(ErrorInfo errorInfo) {
        if (errorInfo == null) {
            return null;
        }
        return new ErrorJSON(errorInfo.getCode(), errorInfo.getErrorMessage(), errorInfo.getParameters());
    }
}

