/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import java.util.Observable;
import java.util.Observer;
import oracle.jvm.hotspot.jfr.JFRStreamWriter;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public final class JavaStringConstantPool
extends VMObject {
    private static long OFF_POS = 0L;
    private static long OFF_OFFSET = 4L;
    private static long OFF_DATA = 8L;
    private static long EVENT_HEADER_SIZE = 32L;
    private static AddressField dataField;
    private static AddressField nextField;

    public JavaStringConstantPool(Address addr) {
        super(addr);
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JavaConstantPools::JavaStringConstantPool");
        dataField = type.getAddressField("_data");
        nextField = type.getAddressField("_next");
    }

    public Address getNext() {
        return nextField.getValue(this.addr);
    }

    public Address getData() {
        return dataField.getValue(this.addr);
    }

    public boolean write(JFRStreamWriter sw) {
        int pos = 0;
        int count = 0;
        int index = 0;
        int offset = 0;
        System.out.println("JavStringConstantPool _data: " + this.getData());
        pos = this.getData().getJIntAt(OFF_POS);
        System.out.println("JavaStringConstantPool pos=" + pos);
        if (pos == 0) {
            return true;
        }
        offset = this.getData().getJIntAt(OFF_OFFSET);
        index = this.getData().getJIntAt(pos);
        count = index - offset;
        long event_size = EVENT_HEADER_SIZE + (long)pos - OFF_DATA;
        Address buf = this.getData().addOffsetTo(OFF_DATA);
        int buffer_len = (int)((long)pos - OFF_DATA);
        byte[] buffer = new byte[buffer_len];
        for (int i = 0; i < buffer_len; ++i) {
            buffer[i] = buf.getJByteAt(i);
        }
        sw.writeJavaConstantPoolCheckpoint(event_size, buffer, buffer_len, index, count);
        return true;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                JavaStringConstantPool.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

