/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher;

import com.jetbrains.launcher.AppExitCode;
import com.jetbrains.launcher.AppProxyException;
import com.jetbrains.launcher.ApplicationFacade;
import com.jetbrains.launcher.ConfiguringService;
import com.jetbrains.launcher.RunningService;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.launcher.contexts.ApplicationContext;
import com.jetbrains.launcher.contexts.ConfiguringContext;
import com.jetbrains.launcher.contexts.ShutdownContext;
import com.jetbrains.launcher.contexts.StartupContext;
import com.jetbrains.launcher.contexts.StatusContext;
import com.jetbrains.launcher.exceptions.ConfiguringException;
import com.jetbrains.launcher.exceptions.ShutdownException;
import com.jetbrains.launcher.exceptions.StartupException;
import com.jetbrains.launcher.exceptions.StatusException;
import com.jetbrains.launcher.util.ClassLoaderContextFactory;
import com.jetbrains.launcher.util.NamedDaemonThreadFactory;
import com.jetbrains.launcher.util.NamedThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class AppProxy
implements ApplicationFacade {
    @NotNull
    private final ExecutorService myDaemonExecutor;
    @NotNull
    private final ExecutorService myNonDaemonExecutor;
    @NotNull
    private final ApplicationFacade myAppWrapper;

    public AppProxy(final @NotNull ClassLoader appClassLoader, final @NotNull String appWrapperClassName) throws AppProxyException {
        if (appClassLoader == null) {
            AppProxy.$$$reportNull$$$0(0);
        }
        if (appWrapperClassName == null) {
            AppProxy.$$$reportNull$$$0(1);
        }
        this.myDaemonExecutor = Executors.newCachedThreadPool(new ClassLoaderContextFactory(appClassLoader, (ThreadFactory)new NamedDaemonThreadFactory("Daemon Proxy")));
        this.myNonDaemonExecutor = AppProxy.createNonDaemonExecutorService(new ClassLoaderContextFactory(appClassLoader, (ThreadFactory)new NamedThreadFactory("Proxy")));
        try {
            Class appWrapperClass;
            try {
                appWrapperClass = (Class)this.callDaemon(new Callable<Class<?>>(){

                    @Override
                    public Class<?> call() throws ClassNotFoundException {
                        return Class.forName(appWrapperClassName, true, appClassLoader);
                    }
                }, ClassNotFoundException.class);
            }
            catch (ClassNotFoundException e) {
                throw new AppProxyException("Application wrapper class is not found: " + appWrapperClassName, e);
            }
            if (!ApplicationFacade.class.isAssignableFrom(appWrapperClass)) {
                throw new AppProxyException("Application wrapper class does not implement \"" + ApplicationFacade.class.getName() + "\" interface: " + appWrapperClass.getName());
            }
            try {
                this.myAppWrapper = this.callDaemon(new Callable<ApplicationFacade>(){

                    @Override
                    public ApplicationFacade call() throws Exception {
                        return (ApplicationFacade)appWrapperClass.newInstance();
                    }
                }, Exception.class);
            }
            catch (Exception e) {
                throw new AppProxyException("Failed to create application wrapper instance: " + e.getMessage(), e);
            }
        }
        catch (AppProxyException e) {
            this.dispose();
            throw e;
        }
    }

    @NotNull
    private static ExecutorService createNonDaemonExecutorService(@NotNull ThreadFactory threadFactory) {
        if (threadFactory == null) {
            AppProxy.$$$reportNull$$$0(2);
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        if (threadPoolExecutor == null) {
            AppProxy.$$$reportNull$$$0(3);
        }
        return threadPoolExecutor;
    }

    @NotNull
    public ConfiguringService createConfiguringService(final @NotNull ApplicationContext appContext) {
        if (appContext == null) {
            AppProxy.$$$reportNull$$$0(4);
        }
        final ConfiguringService configuringService = this.callDaemon(new Callable<ConfiguringService>(){

            @Override
            public ConfiguringService call() {
                return AppProxy.this.myAppWrapper.createConfiguringService(appContext);
            }
        }, RuntimeException.class);
        ConfiguringService configuringService2 = new ConfiguringService(){

            public void configure(final @NotNull ConfiguringContext context) throws ConfiguringException {
                if (context == null) {
                    4.$$$reportNull$$$0(0);
                }
                AppProxy.this.callNonDaemon(new Callable<Void>(){

                    @Override
                    public Void call() throws ConfiguringException {
                        configuringService.configure(context);
                        return null;
                    }
                }, ConfiguringException.class);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/launcher/AppProxy$4", "configure"));
            }
        };
        if (configuringService2 == null) {
            AppProxy.$$$reportNull$$$0(5);
        }
        return configuringService2;
    }

    @NotNull
    public RunningService createRunningService(final @NotNull ApplicationContext appContext) {
        if (appContext == null) {
            AppProxy.$$$reportNull$$$0(6);
        }
        final RunningService runningService = this.callDaemon(new Callable<RunningService>(){

            @Override
            public RunningService call() {
                return AppProxy.this.myAppWrapper.createRunningService(appContext);
            }
        }, RuntimeException.class);
        RunningService runningService2 = new RunningService(){

            public void start(final @NotNull StartupContext context) throws StartupException {
                if (context == null) {
                    6.$$$reportNull$$$0(0);
                }
                AppProxy.this.callNonDaemon(new Callable<Void>(){

                    @Override
                    public Void call() throws StartupException {
                        runningService.start(context);
                        return null;
                    }
                }, StartupException.class);
            }

            @NotNull
            public StatusDescriptor getStatus(final @NotNull StatusContext context) throws StatusException {
                if (context == null) {
                    6.$$$reportNull$$$0(1);
                }
                StatusDescriptor statusDescriptor = (StatusDescriptor)AppProxy.this.callDaemon(new Callable<StatusDescriptor>(){

                    @Override
                    public StatusDescriptor call() throws StatusException {
                        return runningService.getStatus(context);
                    }
                }, StatusException.class);
                if (statusDescriptor == null) {
                    6.$$$reportNull$$$0(2);
                }
                return statusDescriptor;
            }

            @NotNull
            public AppExitCode shutdown(final @NotNull ShutdownContext context) throws ShutdownException {
                if (context == null) {
                    6.$$$reportNull$$$0(3);
                }
                AppExitCode appExitCode = (AppExitCode)AppProxy.this.callDaemon(new Callable<AppExitCode>(){

                    @Override
                    public AppExitCode call() throws ShutdownException {
                        return runningService.shutdown(context);
                    }
                }, ShutdownException.class);
                if (appExitCode == null) {
                    6.$$$reportNull$$$0(4);
                }
                return appExitCode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/launcher/AppProxy$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/launcher/AppProxy$6";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getStatus";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "shutdown";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getStatus";
                        break;
                    }
                    case 2: 
                    case 4: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "shutdown";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (runningService2 == null) {
            AppProxy.$$$reportNull$$$0(7);
        }
        return runningService2;
    }

    public void dispose() {
        this.myDaemonExecutor.shutdownNow();
        this.myNonDaemonExecutor.shutdownNow();
    }

    private <T, E extends Throwable> T callDaemon(@NotNull Callable<T> task, @NotNull Class<E> exceptionClass) throws E {
        if (task == null) {
            AppProxy.$$$reportNull$$$0(8);
        }
        if (exceptionClass == null) {
            AppProxy.$$$reportNull$$$0(9);
        }
        return AppProxy.doCall(this.myDaemonExecutor, task, exceptionClass);
    }

    private <T, E extends Throwable> T callNonDaemon(@NotNull Callable<T> task, @NotNull Class<E> exceptionClass) throws E {
        if (task == null) {
            AppProxy.$$$reportNull$$$0(10);
        }
        if (exceptionClass == null) {
            AppProxy.$$$reportNull$$$0(11);
        }
        return AppProxy.doCall(this.myNonDaemonExecutor, task, exceptionClass);
    }

    private static <T, E extends Throwable> T doCall(@NotNull ExecutorService executor, @NotNull Callable<T> task, @NotNull Class<E> exceptionClass) throws E {
        if (executor == null) {
            AppProxy.$$$reportNull$$$0(12);
        }
        if (task == null) {
            AppProxy.$$$reportNull$$$0(13);
        }
        if (exceptionClass == null) {
            AppProxy.$$$reportNull$$$0(14);
        }
        try {
            return executor.submit(task).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (exceptionClass.isInstance(cause)) {
                throw (Throwable)exceptionClass.cast(cause);
            }
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appClassLoader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appWrapperClassName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadFactory";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/AppProxy";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appContext";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/AppProxy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNonDaemonExecutorService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfiguringService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunningService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNonDaemonExecutorService";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConfiguringService";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRunningService";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "callDaemon";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "callNonDaemon";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

