/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.transport;

import com.jetbrains.launcher.transport.Request;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CriticalRequestsHolder {
    @NotNull
    private final List<Future<?>> myCriticalRequestFutures = new ArrayList();
    @NotNull
    private final Set<String> myCriticalUrls = new HashSet<String>();

    CriticalRequestsHolder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCriticalUrl(@NotNull String url) {
        if (url == null) {
            CriticalRequestsHolder.$$$reportNull$$$0(0);
        }
        Set<String> set = this.myCriticalUrls;
        synchronized (set) {
            this.myCriticalUrls.add(url);
        }
    }

    @NotNull
    public FutureRequestMatcher createNewFutureRequestMatcher() {
        FutureRequestMatcherImpl futureRequestMatcherImpl = new FutureRequestMatcherImpl();
        if (futureRequestMatcherImpl == null) {
            CriticalRequestsHolder.$$$reportNull$$$0(1);
        }
        return futureRequestMatcherImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCriticalRequests() {
        ArrayList criticalRequestFutures;
        List<Future<?>> list = this.myCriticalRequestFutures;
        synchronized (list) {
            criticalRequestFutures = new ArrayList(this.myCriticalRequestFutures);
            this.myCriticalRequestFutures.clear();
        }
        for (Future future : criticalRequestFutures) {
            try {
                future.get();
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCritical(@NotNull Request request) {
        if (request == null) {
            CriticalRequestsHolder.$$$reportNull$$$0(2);
        }
        Set<String> set = this.myCriticalUrls;
        synchronized (set) {
            return this.myCriticalUrls.contains(request.getURL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCriticalRequestFuture(@NotNull Future<?> criticalRequestFuture) {
        if (criticalRequestFuture == null) {
            CriticalRequestsHolder.$$$reportNull$$$0(3);
        }
        List<Future<?>> list = this.myCriticalRequestFutures;
        synchronized (list) {
            this.myCriticalRequestFutures.add(criticalRequestFuture);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/transport/CriticalRequestsHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "criticalRequestFuture";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/transport/CriticalRequestsHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewFutureRequestMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCriticalUrl";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCritical";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addCriticalRequestFuture";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FutureRequestMatcherImpl
    implements FutureRequestMatcher {
        @NotNull
        private final Semaphore myCheckSemaphore = new Semaphore(1);
        @Nullable
        private volatile Future<?> myFuture;
        @Nullable
        private volatile Request myRequest;

        private FutureRequestMatcherImpl() {
        }

        @Override
        public void setFuture(@NotNull Future<?> future) {
            if (future == null) {
                FutureRequestMatcherImpl.$$$reportNull$$$0(0);
            }
            this.myFuture = future;
            this.checkData();
        }

        @Override
        public void setRequest(@NotNull Request request) {
            if (request == null) {
                FutureRequestMatcherImpl.$$$reportNull$$$0(1);
            }
            this.myRequest = request;
            this.checkData();
        }

        private void checkData() {
            Future<?> future = this.myFuture;
            Request request = this.myRequest;
            if (future != null && request != null && this.myCheckSemaphore.tryAcquire() && CriticalRequestsHolder.this.isCritical(request)) {
                CriticalRequestsHolder.this.addCriticalRequestFuture(future);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "future";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/launcher/transport/CriticalRequestsHolder$FutureRequestMatcherImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setFuture";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setRequest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface FutureRequestMatcher {
        public void setFuture(@NotNull Future<?> var1);

        public void setRequest(@NotNull Request var1);
    }
}

