/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import javax.management.MBeanServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HotSpotDiagnosticMXBeanWrapper {
    @NotNull
    private static final String MXBEAN_CLASS_NAME = "com.sun.management.HotSpotDiagnosticMXBean";
    @NotNull
    private static final String MXBEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    @Nullable
    private final Object myHotSpotDiagnosticMXBean = HotSpotDiagnosticMXBeanWrapper.createHotSpotDiagnosticMXBean();
    @Nullable
    private final Method myDumpHeapMethod = HotSpotDiagnosticMXBeanWrapper.getDumpHeapMethod(this.myHotSpotDiagnosticMXBean);

    @Nullable
    private static Object createHotSpotDiagnosticMXBean() {
        try {
            Class<?> mxBeanClass = Class.forName(MXBEAN_CLASS_NAME);
            MBeanServer mxBeanServer = ManagementFactory.getPlatformMBeanServer();
            return ManagementFactory.newPlatformMXBeanProxy(mxBeanServer, MXBEAN_NAME, mxBeanClass);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Nullable
    private static Method getDumpHeapMethod(@Nullable Object bean) {
        try {
            return bean == null ? null : bean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public boolean dumpHeapToFile(@NotNull File file) {
        if (file == null) {
            HotSpotDiagnosticMXBeanWrapper.$$$reportNull$$$0(0);
        }
        if (this.myHotSpotDiagnosticMXBean != null && this.myDumpHeapMethod != null) {
            try {
                this.myDumpHeapMethod.invoke(this.myHotSpotDiagnosticMXBean, file.getAbsolutePath(), false);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/launcher/util/HotSpotDiagnosticMXBeanWrapper", "dumpHeapToFile"));
    }
}

