/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher;

import com.jetbrains.launcher.Status;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusDescriptor {
    @NotNull
    public static final StatusDescriptor ERROR = new StatusDescriptor(Status.ERROR, null);
    @NotNull
    public static final StatusDescriptor SHUT_DOWN = new StatusDescriptor(Status.SHUT_DOWN, null);
    private static final char SEPARATOR_CHAR = ':';
    @NotNull
    private final Status myStatus;
    @Nullable
    private final String myDescription;

    public StatusDescriptor(@NotNull Status status, @Nullable String description) {
        if (status == null) {
            StatusDescriptor.$$$reportNull$$$0(0);
        }
        this.myStatus = status;
        this.myDescription = description;
    }

    public boolean isAlive() {
        return this.myStatus.isAlive();
    }

    public boolean is(@NotNull Status status) {
        if (status == null) {
            StatusDescriptor.$$$reportNull$$$0(1);
        }
        return this.myStatus == status;
    }

    @NotNull
    public Status getStatus() {
        Status status = this.myStatus;
        if (status == null) {
            StatusDescriptor.$$$reportNull$$$0(2);
        }
        return status;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    @NotNull
    public String asHumanReadableString(@NotNull String appDisplayName) {
        if (appDisplayName == null) {
            StatusDescriptor.$$$reportNull$$$0(3);
        }
        StringBuilder sb = new StringBuilder(appDisplayName);
        if (this.myStatus == Status.ERROR) {
            sb.append(" failed to report status");
        } else {
            sb.append(" is ").append(this.myStatus.getText());
        }
        if (this.myDescription != null) {
            sb.append(" (").append(this.myDescription).append(")");
        }
        String string = sb.toString();
        if (string == null) {
            StatusDescriptor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String asString() {
        StringBuilder sb = new StringBuilder(this.myStatus.name());
        if (this.myDescription != null) {
            sb.append(':').append(this.myDescription);
        }
        String string = sb.toString();
        if (string == null) {
            StatusDescriptor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static StatusDescriptor parse(@Nullable String statusText) {
        String description;
        Status status;
        if (statusText == null) {
            StatusDescriptor statusDescriptor = ERROR;
            if (statusDescriptor == null) {
                StatusDescriptor.$$$reportNull$$$0(6);
            }
            return statusDescriptor;
        }
        int sepPos = statusText.indexOf(58);
        if (sepPos == -1) {
            status = Status.parse(statusText);
            description = null;
        } else {
            status = Status.parse(statusText.substring(0, sepPos));
            description = statusText.substring(sepPos + 1);
        }
        StatusDescriptor statusDescriptor = status == null ? StatusDescriptor.error("Failed to parse status: " + statusText) : new StatusDescriptor(status, description);
        if (statusDescriptor == null) {
            StatusDescriptor.$$$reportNull$$$0(7);
        }
        return statusDescriptor;
    }

    @NotNull
    public static StatusDescriptor error(@Nullable String description) {
        StatusDescriptor statusDescriptor = description == null ? ERROR : new StatusDescriptor(Status.ERROR, description);
        if (statusDescriptor == null) {
            StatusDescriptor.$$$reportNull$$$0(8);
        }
        return statusDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/StatusDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/StatusDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "asHumanReadableString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "asHumanReadableString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

