/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher;

import com.jetbrains.launcher.DestroyerStep;
import com.jetbrains.launcher.JLThread;
import com.jetbrains.launcher.ProcessContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Destroyer {
    @NotNull
    private static final ProcessContext.Key<Destroyer> DESTROYER_KEY = new ProcessContext.Key<Destroyer>(){

        @Override
        @NotNull
        public Destroyer createDefaultValue() {
            Destroyer destroyer = new Destroyer(null);
            if (destroyer == null) {
                1.$$$reportNull$$$0(0);
            }
            return destroyer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/Destroyer$1", "createDefaultValue"));
        }
    };
    @NotNull
    private final ProcessContext myProcessContext;
    @NotNull
    private final List<Destroyer> myChildren = new ArrayList<Destroyer>();
    @NotNull
    private final List<Runnable> myActions = new ArrayList<Runnable>();
    @NotNull
    private final Object myLock = new Object();
    @Nullable
    private Thread myDestroyerThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Destroyer(@Nullable Destroyer parentDestroyer) {
        this.myProcessContext = ProcessContext.get();
        if (parentDestroyer != null) {
            Object object = parentDestroyer.myLock;
            synchronized (object) {
                if (parentDestroyer.myDestroyerThread != null) {
                    throw new IllegalStateException("Parent is already destroyed");
                }
                parentDestroyer.myChildren.add(0, this);
            }
        }
        final JLThread shutdownHook = new JLThread("Destroyer"){

            @Override
            public void run() {
                Destroyer.this.destroyAll();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        this.addStep(new Runnable(){

            @Override
            public void run() {
                try {
                    Runtime.getRuntime().removeShutdownHook(shutdownHook);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static void initChildDestroyer(@NotNull Destroyer parentDestroyer) {
        if (parentDestroyer == null) {
            Destroyer.$$$reportNull$$$0(0);
        }
        ProcessContext.get().setValue(DESTROYER_KEY, new Destroyer(parentDestroyer));
    }

    @NotNull
    public static Destroyer get() {
        Destroyer destroyer = ProcessContext.get().getOrCreateValue(DESTROYER_KEY);
        if (destroyer == null) {
            Destroyer.$$$reportNull$$$0(1);
        }
        return destroyer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DestroyerStep addStep(final @NotNull Runnable action) {
        if (action == null) {
            Destroyer.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDestroyerThread != null && !Thread.currentThread().equals(this.myDestroyerThread)) {
                action.run();
                throw new IllegalStateException("Already destroyed");
            }
            this.myActions.add(0, action);
        }
        DestroyerStep destroyerStep = new DestroyerStep(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                Object object = Destroyer.this.myLock;
                synchronized (object) {
                    Destroyer.this.myActions.remove(action);
                }
            }
        };
        if (destroyerStep == null) {
            Destroyer.$$$reportNull$$$0(3);
        }
        return destroyerStep;
    }

    public void destroyAll() {
        for (Destroyer child : this.copyAndClear(this.myChildren, false)) {
            child.destroyAll();
        }
        this.destroy();
    }

    public synchronized void destroy() {
        this.myProcessContext.runInContext(new Runnable(){

            @Override
            public void run() {
                for (Runnable action : Destroyer.this.copyAndClear(Destroyer.this.myActions, true)) {
                    action.run();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroying() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myDestroyerThread != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private <T> List<T> copyAndClear(@NotNull List<T> list, boolean setDestroyerThread) {
        ArrayList<T> arrayList;
        if (list == null) {
            Destroyer.$$$reportNull$$$0(4);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (setDestroyerThread) {
                if (this.myDestroyerThread != null) {
                    List list2 = Collections.emptyList();
                    // MONITOREXIT @DISABLED, blocks:[4, 9, 10] lbl8 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (list2 == null) {
                        Destroyer.$$$reportNull$$$0(5);
                    }
                    return list2;
                }
                this.myDestroyerThread = Thread.currentThread();
            }
            ArrayList<T> arrayList2 = new ArrayList<T>(list);
            // MONITOREXIT @DISABLED, blocks:[2, 4] lbl15 : MonitorExitStatement: MONITOREXIT : var3_3
            arrayList = arrayList2;
        }
        if (arrayList == null) {
            Destroyer.$$$reportNull$$$0(6);
        }
        return arrayList;
        {
            finally {
                list.clear();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDestroyer";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/Destroyer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/Destroyer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addStep";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAndClear";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initChildDestroyer";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addStep";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyAndClear";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

