/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemInfo {
    public static final String EOL = System.getProperty("line.separator", "\n");
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH;
    public static final boolean isWindows;
    public static final boolean isWindowsXP;
    public static final boolean isMac;
    public static final boolean isLinux;
    public static final boolean isSolaris;
    public static final boolean isFreeBSD;
    public static final boolean isAIX;
    public static final boolean isJvm64Bit;
    public static final boolean isX86;
    public static final boolean isAMD;
    public static final boolean isPPC;
    public static final boolean isSPARC;
    public static final boolean isRootUser;

    @NotNull
    private static String getNotNullLowerCase(@Nullable String string) {
        String string2 = string == null ? "" : string.toLowerCase();
        if (string2 == null) {
            SystemInfo.$$$reportNull$$$0(0);
        }
        return string2;
    }

    static {
        String notNullLowerCaseOSName = SystemInfo.getNotNullLowerCase(OS_NAME);
        isWindows = notNullLowerCaseOSName.contains("windows");
        isWindowsXP = notNullLowerCaseOSName.contains("windows xp");
        isMac = notNullLowerCaseOSName.contains("mac");
        isLinux = notNullLowerCaseOSName.contains("linux");
        isSolaris = notNullLowerCaseOSName.contains("solaris") || notNullLowerCaseOSName.contains("sunos");
        isFreeBSD = notNullLowerCaseOSName.contains("freebsd");
        isAIX = notNullLowerCaseOSName.contains("aix");
        OS_ARCH = System.getProperty("os.arch");
        String notNullLowerCaseOSArch = SystemInfo.getNotNullLowerCase(OS_ARCH);
        isJvm64Bit = notNullLowerCaseOSArch.contains("64");
        isX86 = notNullLowerCaseOSArch.contains("x86");
        isAMD = notNullLowerCaseOSArch.contains("amd");
        isPPC = notNullLowerCaseOSArch.contains("ppc");
        isSPARC = notNullLowerCaseOSArch.contains("sparc");
        isRootUser = "root".equals(System.getProperty("user.name"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/SystemInfo", "getNotNullLowerCase"));
    }
}

