/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import com.jetbrains.launcher.PathResolver;
import com.jetbrains.launcher.util.PropertiesUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfiguringArgumentsParser {
    @NotNull
    public static final String PROPERTY_PREFIX = "--";
    @NotNull
    public static final String PROPERTY_VALUE_SEPARATOR = "=";
    @NotNull
    public static final String FILE_OPTION = "-f";
    @NotNull
    public static final String JVM_OPTION_PREFIX = "-J";
    @NotNull
    private final List<PropertiesLoader> myLoaders;
    @NotNull
    private final List<String> myJvmOptions;
    @Nullable
    private Map<String, String> myProperties;

    public ConfiguringArgumentsParser(@NotNull List<String> args, @NotNull PathResolver pathResolver) {
        if (args == null) {
            ConfiguringArgumentsParser.$$$reportNull$$$0(0);
        }
        if (pathResolver == null) {
            ConfiguringArgumentsParser.$$$reportNull$$$0(1);
        }
        this(args, pathResolver, false);
    }

    public ConfiguringArgumentsParser(@NotNull List<String> args, @NotNull PathResolver pathResolver, boolean allowUnknownArguments) {
        if (args == null) {
            ConfiguringArgumentsParser.$$$reportNull$$$0(2);
        }
        if (pathResolver == null) {
            ConfiguringArgumentsParser.$$$reportNull$$$0(3);
        }
        this(args, pathResolver, allowUnknownArguments, true);
    }

    public ConfiguringArgumentsParser(@NotNull List<String> args, @NotNull PathResolver pathResolver, boolean allowUnknownArguments, boolean parseJvmOptions) {
        if (args == null) {
            ConfiguringArgumentsParser.$$$reportNull$$$0(4);
        }
        if (pathResolver == null) {
            ConfiguringArgumentsParser.$$$reportNull$$$0(5);
        }
        this.myLoaders = new ArrayList<PropertiesLoader>();
        this.myJvmOptions = new ArrayList<String>();
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            if (arg.startsWith(PROPERTY_PREFIX)) {
                int startPos = PROPERTY_PREFIX.length();
                int sepPos = arg.indexOf(PROPERTY_VALUE_SEPARATOR, startPos);
                if (sepPos == -1) {
                    if (++i < args.size()) {
                        this.myLoaders.add(new SinglePropertyLoader(arg.substring(startPos), args.get(i)));
                        continue;
                    }
                    throw new IllegalArgumentException("No value is specified for the \"" + arg + "\" option");
                }
                this.myLoaders.add(new SinglePropertyLoader(arg.substring(startPos, sepPos), arg.substring(sepPos + PROPERTY_VALUE_SEPARATOR.length())));
                continue;
            }
            if (arg.equals(FILE_OPTION)) {
                if (++i < args.size()) {
                    this.myLoaders.add(new FilePropertiesLoader(pathResolver.resolvePath(args.get(i))));
                    continue;
                }
                throw new IllegalArgumentException("No file is specified for the \"" + arg + "\" option");
            }
            if (arg.startsWith(JVM_OPTION_PREFIX)) {
                if (parseJvmOptions) {
                    this.myJvmOptions.add(arg.substring(JVM_OPTION_PREFIX.length()));
                    continue;
                }
                throw new IllegalArgumentException("Cannot configure JVM options");
            }
            if (allowUnknownArguments) continue;
            throw new IllegalArgumentException("Unknown argument: " + arg);
        }
    }

    @NotNull
    public Map<String, String> getProperties() throws IOException {
        if (this.myProperties == null) {
            Properties properties = new Properties();
            for (PropertiesLoader loader : this.myLoaders) {
                loader.loadTo(properties);
            }
            this.myProperties = PropertiesUtil.toMap(properties);
        }
        Map<String, String> map = Collections.unmodifiableMap(this.myProperties);
        if (map == null) {
            ConfiguringArgumentsParser.$$$reportNull$$$0(6);
        }
        return map;
    }

    @NotNull
    public List<String> getJvmOptions() {
        List<String> list = Collections.unmodifiableList(this.myJvmOptions);
        if (list == null) {
            ConfiguringArgumentsParser.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/ConfiguringArgumentsParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/ConfiguringArgumentsParser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getJvmOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SinglePropertyLoader
    implements PropertiesLoader {
        @NotNull
        private final String myName;
        @NotNull
        private final String myValue;

        private SinglePropertyLoader(@NotNull String name, @NotNull String value) {
            if (name == null) {
                SinglePropertyLoader.$$$reportNull$$$0(0);
            }
            if (value == null) {
                SinglePropertyLoader.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myValue = value;
        }

        @Override
        public void loadTo(@NotNull Properties properties) {
            if (properties == null) {
                SinglePropertyLoader.$$$reportNull$$$0(2);
            }
            properties.put(this.myName, this.myValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/launcher/util/ConfiguringArgumentsParser$SinglePropertyLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FilePropertiesLoader
    implements PropertiesLoader {
        @NotNull
        private final File myFile;

        private FilePropertiesLoader(@NotNull File file) {
            if (file == null) {
                FilePropertiesLoader.$$$reportNull$$$0(0);
            }
            this.myFile = file;
        }

        @Override
        public void loadTo(@NotNull Properties properties) throws IOException {
            if (properties == null) {
                FilePropertiesLoader.$$$reportNull$$$0(1);
            }
            PropertiesUtil.loadFromFile(properties, this.myFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/launcher/util/ConfiguringArgumentsParser$FilePropertiesLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface PropertiesLoader {
        public void loadTo(@NotNull Properties var1) throws IOException;
    }
}

