/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import com.jetbrains.launcher.Destroyer;
import com.jetbrains.launcher.DestroyerStep;
import com.jetbrains.launcher.Static;
import com.jetbrains.launcher.SystemInfo;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.TimeoutException;
import com.jetbrains.launcher.util.process.ProcessHandler;
import com.jetbrains.launcher.util.process.ProcessOutputLineListener;
import com.jetbrains.launcher.util.process.ProcessOutputPart;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.management.VMManagement;

public class ProcessUtil {
    @Static
    @Nullable
    private static Integer ourPid;

    public static boolean isAlive(@NotNull Process process) {
        if (process == null) {
            ProcessUtil.$$$reportNull$$$0(0);
        }
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public static int kill(int pid) throws IOException {
        if (SystemInfo.isWindows) {
            return ProcessUtil.runSimpleCommand("taskkill", "/pid", String.valueOf(pid), "/t", "/f");
        }
        return ProcessUtil.runSimpleCommand("kill", "-9", String.valueOf(pid));
    }

    @NotNull
    public static String getCurrentPidDescription() {
        String string;
        try {
            string = String.valueOf(ProcessUtil.getCurrentPid());
        }
        catch (IOException e) {
            String string2 = "Unknown (" + e + ")";
            if (string2 == null) {
                ProcessUtil.$$$reportNull$$$0(2);
            }
            return string2;
        }
        if (string == null) {
            ProcessUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static int getCurrentPid() throws IOException {
        if (ourPid == null) {
            ourPid = ProcessUtil.doGetCurrentPid();
        }
        return ourPid;
    }

    private static int doGetCurrentPid() throws IOException {
        try {
            return ProcessUtil.getCurrentPidFromSystemProperty();
        }
        catch (Exception e1) {
            try {
                return ProcessUtil.getCurrentPidFromJVMName();
            }
            catch (Exception e2) {
                try {
                    return ProcessUtil.getCurrentPidFromMXBeanByReflection();
                }
                catch (Exception e3) {
                    throw new IOException("Failed to determine current process ID: " + e1 + "; " + e2 + "; " + e3 + ".");
                }
            }
        }
    }

    private static int getCurrentPidFromSystemProperty() throws Exception {
        String pidPropertyName = "sun.java.launcher.pid";
        String pidPropertyValue = System.getProperty("sun.java.launcher.pid");
        try {
            return Integer.parseInt(pidPropertyValue);
        }
        catch (NumberFormatException e) {
            throw new Exception("Failed to parse \"sun.java.launcher.pid\" property value: " + pidPropertyValue);
        }
    }

    private static int getCurrentPidFromJVMName() throws Exception {
        int separatorPos;
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        if (jvmName != null && (separatorPos = jvmName.indexOf(64)) != -1) {
            try {
                return Integer.parseInt(jvmName.substring(0, separatorPos).trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new Exception("Failed to parse JVM name: " + jvmName);
    }

    private static int getCurrentPidFromMXBeanByReflection() throws Exception {
        try {
            RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();
            Field jvmField = mxBean.getClass().getDeclaredField("jvm");
            jvmField.setAccessible(true);
            VMManagement vmManagement = (VMManagement)jvmField.get(mxBean);
            Method getPidMethod = vmManagement.getClass().getDeclaredMethod("getProcessId", new Class[0]);
            getPidMethod.setAccessible(true);
            return (Integer)getPidMethod.invoke((Object)vmManagement, new Object[0]);
        }
        catch (Exception e) {
            throw new Exception("Failed to get PID from MX bean: " + e, e);
        }
    }

    public static int runSimpleCommand(String ... command) throws IOException {
        if (command == null) {
            ProcessUtil.$$$reportNull$$$0(3);
        }
        final Process process = new ProcessBuilder(command).start();
        FileUtil.close(process.getOutputStream());
        FileUtil.close(process.getErrorStream());
        FileUtil.close(process.getInputStream());
        DestroyerStep destroyerStep = Destroyer.get().addStep(new Runnable(){

            @Override
            public void run() {
                process.destroy();
            }
        });
        try {
            int n = process.waitFor();
            return n;
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            destroyerStep.remove();
        }
    }

    @NotNull
    public static ExecutionResult runCommand(@Nullable Integer timeoutSeconds, String ... command) throws IOException, TimeoutException {
        if (command == null) {
            ProcessUtil.$$$reportNull$$$0(4);
        }
        ExecutionResult executionResult = ProcessUtil.runCommand(true, timeoutSeconds, command);
        if (executionResult == null) {
            ProcessUtil.$$$reportNull$$$0(5);
        }
        return executionResult;
    }

    @NotNull
    public static ExecutionResult runCommand(boolean assertZeroExitCode, @Nullable Integer timeoutSeconds, String ... command) throws IOException, TimeoutException {
        int exitCode;
        if (command == null) {
            ProcessUtil.$$$reportNull$$$0(6);
        }
        Process process = new ProcessBuilder(command).start();
        final ArrayList<String> stdout = new ArrayList<String>();
        final ArrayList<String> stderr = new ArrayList<String>();
        ProcessHandler processHandler = ProcessHandler.builder(process).withListener(new ProcessOutputLineListener(){

            @Override
            protected void outputLine(@NotNull ProcessOutputPart line) {
                if (line == null) {
                    2.$$$reportNull$$$0(0);
                }
                stdout.add(line.getText());
            }

            @Override
            protected void errorLine(@NotNull ProcessOutputPart line) {
                if (line == null) {
                    2.$$$reportNull$$$0(1);
                }
                stderr.add(line.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "line";
                objectArray2[1] = "com/jetbrains/launcher/util/ProcessUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "outputLine";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorLine";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).build();
        processHandler.start();
        try {
            exitCode = processHandler.waitForProcess(timeoutSeconds);
            if (assertZeroExitCode && exitCode != 0) {
                throw new IOException("Process exited with code " + exitCode);
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (TimeoutException e) {
            processHandler.cancel();
            throw e;
        }
        finally {
            processHandler.finish();
        }
        ExecutionResult executionResult = new ExecutionResult(stdout, stderr, exitCode);
        if (executionResult == null) {
            ProcessUtil.$$$reportNull$$$0(7);
        }
        return executionResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/ProcessUtil";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/ProcessUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentPidDescription";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "runCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAlive";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runSimpleCommand";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ExecutionResult {
        @NotNull
        private final List<String> myStdout;
        @NotNull
        private final List<String> myStderr;
        private final int myExitCode;

        public ExecutionResult(@NotNull List<String> stdout, @NotNull List<String> stderr, int exitCode) {
            if (stdout == null) {
                ExecutionResult.$$$reportNull$$$0(0);
            }
            if (stderr == null) {
                ExecutionResult.$$$reportNull$$$0(1);
            }
            this.myStdout = stdout;
            this.myStderr = stderr;
            this.myExitCode = exitCode;
        }

        @NotNull
        public List<String> getStdout() {
            List<String> list = this.myStdout;
            if (list == null) {
                ExecutionResult.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        public List<String> getStderr() {
            List<String> list = this.myStderr;
            if (list == null) {
                ExecutionResult.$$$reportNull$$$0(3);
            }
            return list;
        }

        public int getExitCode() {
            return this.myExitCode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stdout";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stderr";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/launcher/util/ProcessUtil$ExecutionResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/launcher/util/ProcessUtil$ExecutionResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStdout";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStderr";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

