/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util.process;

import com.jetbrains.launcher.Destroyer;
import com.jetbrains.launcher.DestroyerStep;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.ProcessUtil;
import com.jetbrains.launcher.util.TimeoutException;
import com.jetbrains.launcher.util.WaitFor;
import com.jetbrains.launcher.util.process.ProcessOutputListener;
import com.jetbrains.launcher.util.process.ProcessOutputPart;
import com.jetbrains.launcher.util.process.ProcessOutputReader;
import com.jetbrains.launcher.util.stream.AbstractAsyncReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessHandler {
    @NotNull
    private final Process myProcess;
    @Nullable
    private final Runnable myProcessDestroyer;
    @NotNull
    private final Reader myOutput;
    @NotNull
    private final Reader myError;
    @NotNull
    private final DestroyerStep myDestroyerStep;

    @NotNull
    public static ProcessHandlerPreBuilder builder(@NotNull Process process) {
        if (process == null) {
            ProcessHandler.$$$reportNull$$$0(0);
        }
        ProcessHandlerPreBuilder processHandlerPreBuilder = new ProcessHandlerPreBuilder(process);
        if (processHandlerPreBuilder == null) {
            ProcessHandler.$$$reportNull$$$0(1);
        }
        return processHandlerPreBuilder;
    }

    private ProcessHandler(@NotNull Process process, final @NotNull ProcessOutputListener outputListener, @Nullable String stdoutPrefix, @Nullable String stderrPrefix, @Nullable Runnable processDestroyer, final boolean destroyProcessOnExit) {
        if (process == null) {
            ProcessHandler.$$$reportNull$$$0(2);
        }
        if (outputListener == null) {
            ProcessHandler.$$$reportNull$$$0(3);
        }
        this.myProcess = process;
        this.myProcessDestroyer = processDestroyer;
        this.myOutput = new Reader("Process Output Reader", stdoutPrefix, process.getInputStream()){

            @Override
            protected void log(@NotNull ProcessOutputPart outputPart) {
                if (outputPart == null) {
                    1.$$$reportNull$$$0(0);
                }
                outputListener.output(outputPart);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputPart", "com/jetbrains/launcher/util/process/ProcessHandler$1", "log"));
            }
        };
        this.myError = new Reader("Process Error Reader", stderrPrefix, process.getErrorStream()){

            @Override
            protected void log(@NotNull ProcessOutputPart outputPart) {
                if (outputPart == null) {
                    2.$$$reportNull$$$0(0);
                }
                outputListener.error(outputPart);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputPart", "com/jetbrains/launcher/util/process/ProcessHandler$2", "log"));
            }
        };
        this.myDestroyerStep = Destroyer.get().addStep(new Runnable(){

            @Override
            public void run() {
                ProcessHandler.this.doDestroy(destroyProcessOnExit);
            }
        });
        FileUtil.close(process.getOutputStream());
    }

    public int waitForProcess(@Nullable Integer timeoutSeconds) throws InterruptedException, TimeoutException {
        if (timeoutSeconds == null) {
            return this.myProcess.waitFor();
        }
        new WaitFor<RuntimeException>(Long.valueOf((long)timeoutSeconds.intValue() * 1000L)){

            @Override
            protected boolean condition() {
                return !ProcessHandler.this.isAlive();
            }
        };
        return this.myProcess.exitValue();
    }

    public boolean isAlive() {
        return ProcessUtil.isAlive(this.myProcess);
    }

    public void start() {
        this.myOutput.start();
        this.myError.start();
    }

    public void cancel() {
        this.removeDestroyerStep();
        this.doCancel();
    }

    private void doCancel() {
        this.myOutput.cancel();
        this.myError.cancel();
        this.myOutput.waitFor();
        this.myError.waitFor();
    }

    public void destroy() {
        this.removeDestroyerStep();
        this.doDestroy(true);
    }

    private void doDestroy(boolean mustDestroyProcess) {
        this.doCancel();
        if (mustDestroyProcess) {
            this.destroyProcess();
        }
    }

    private void destroyProcess() {
        if (this.myProcessDestroyer == null) {
            this.myProcess.destroy();
        } else {
            this.myProcessDestroyer.run();
        }
    }

    public void finish() {
        this.removeDestroyerStep();
        this.myOutput.prepareToFinish();
        this.myError.prepareToFinish();
        this.myOutput.waitFor();
        this.myError.waitFor();
    }

    private void removeDestroyerStep() {
        this.myDestroyerStep.remove();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/process/ProcessHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/process/ProcessHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "builder";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class Reader
    extends AbstractAsyncReader<ProcessOutputReader> {
        @Nullable
        private final String myOutputPrefix;

        public Reader(@NotNull String threadName, @Nullable String outputPrefix, @NotNull InputStream source) {
            if (threadName == null) {
                Reader.$$$reportNull$$$0(0);
            }
            if (source == null) {
                Reader.$$$reportNull$$$0(1);
            }
            super(threadName, source);
            this.myOutputPrefix = outputPrefix;
        }

        @Override
        @NotNull
        protected ProcessOutputReader createReader(@NotNull InputStream source) {
            ProcessOutputReader processOutputReader;
            block4: {
                if (source == null) {
                    Reader.$$$reportNull$$$0(2);
                }
                try {
                    processOutputReader = new ProcessOutputReader(new InputStreamReader(source, "UTF-8"));
                    if (processOutputReader != null) break block4;
                }
                catch (UnsupportedEncodingException e) {
                    ProcessOutputReader processOutputReader2 = new ProcessOutputReader(new InputStreamReader(source));
                    if (processOutputReader2 == null) {
                        Reader.$$$reportNull$$$0(4);
                    }
                    return processOutputReader2;
                }
                Reader.$$$reportNull$$$0(3);
            }
            return processOutputReader;
        }

        @Override
        protected boolean doRead(@NotNull ProcessOutputReader reader) throws IOException {
            ProcessOutputPart outputPart;
            if (reader == null) {
                Reader.$$$reportNull$$$0(5);
            }
            if ((outputPart = reader.readNextPart()) == null) {
                return false;
            }
            this.log(this.addPrefixIfNeeded(outputPart));
            return true;
        }

        @NotNull
        private ProcessOutputPart addPrefixIfNeeded(@NotNull ProcessOutputPart outputPart) {
            if (outputPart == null) {
                Reader.$$$reportNull$$$0(6);
            }
            if (this.myOutputPrefix == null || !outputPart.isLineStart()) {
                ProcessOutputPart processOutputPart = outputPart;
                if (processOutputPart == null) {
                    Reader.$$$reportNull$$$0(7);
                }
                return processOutputPart;
            }
            ProcessOutputPart processOutputPart = outputPart.withText(this.myOutputPrefix + outputPart.getText());
            if (processOutputPart == null) {
                Reader.$$$reportNull$$$0(8);
            }
            return processOutputPart;
        }

        protected abstract void log(@NotNull ProcessOutputPart var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/launcher/util/process/ProcessHandler$Reader";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputPart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/launcher/util/process/ProcessHandler$Reader";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createReader";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addPrefixIfNeeded";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createReader";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "doRead";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addPrefixIfNeeded";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ProcessHandlerBuilder {
        @NotNull
        private final Process myProcess;
        @NotNull
        private final ProcessOutputListener myListener;
        @Nullable
        private String myStdoutPrefix;
        @Nullable
        private String myStderrPrefix;
        @Nullable
        private Runnable myDestroyer;
        private boolean myDestroyProcessOnExit;

        public ProcessHandlerBuilder(@NotNull Process process, @NotNull ProcessOutputListener listener) {
            if (process == null) {
                ProcessHandlerBuilder.$$$reportNull$$$0(0);
            }
            if (listener == null) {
                ProcessHandlerBuilder.$$$reportNull$$$0(1);
            }
            this.myDestroyProcessOnExit = true;
            this.myProcess = process;
            this.myListener = listener;
        }

        @NotNull
        public ProcessHandlerBuilder withPrefix(@Nullable String prefix) {
            ProcessHandlerBuilder processHandlerBuilder = this.withStdoutPrefix(prefix).withStderrPrefix(prefix);
            if (processHandlerBuilder == null) {
                ProcessHandlerBuilder.$$$reportNull$$$0(2);
            }
            return processHandlerBuilder;
        }

        @NotNull
        public ProcessHandlerBuilder withStdoutPrefix(@Nullable String stdoutPrefix) {
            this.myStdoutPrefix = stdoutPrefix;
            ProcessHandlerBuilder processHandlerBuilder = this;
            if (processHandlerBuilder == null) {
                ProcessHandlerBuilder.$$$reportNull$$$0(3);
            }
            return processHandlerBuilder;
        }

        @NotNull
        public ProcessHandlerBuilder withStderrPrefix(@Nullable String stderrPrefix) {
            this.myStderrPrefix = stderrPrefix;
            ProcessHandlerBuilder processHandlerBuilder = this;
            if (processHandlerBuilder == null) {
                ProcessHandlerBuilder.$$$reportNull$$$0(4);
            }
            return processHandlerBuilder;
        }

        @NotNull
        public ProcessHandlerBuilder onDestroy(@Nullable Runnable destroyer) {
            this.myDestroyer = destroyer;
            ProcessHandlerBuilder processHandlerBuilder = this;
            if (processHandlerBuilder == null) {
                ProcessHandlerBuilder.$$$reportNull$$$0(5);
            }
            return processHandlerBuilder;
        }

        @NotNull
        public ProcessHandlerBuilder doNotDestroyProcessOnExit() {
            this.myDestroyProcessOnExit = false;
            ProcessHandlerBuilder processHandlerBuilder = this;
            if (processHandlerBuilder == null) {
                ProcessHandlerBuilder.$$$reportNull$$$0(6);
            }
            return processHandlerBuilder;
        }

        @NotNull
        public ProcessHandler build() {
            ProcessHandler processHandler = new ProcessHandler(this.myProcess, this.myListener, this.myStdoutPrefix, this.myStderrPrefix, this.myDestroyer, this.myDestroyProcessOnExit);
            if (processHandler == null) {
                ProcessHandlerBuilder.$$$reportNull$$$0(7);
            }
            return processHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/launcher/util/process/ProcessHandler$ProcessHandlerBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/launcher/util/process/ProcessHandler$ProcessHandlerBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPrefix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withStdoutPrefix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withStderrPrefix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "onDestroy";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doNotDestroyProcessOnExit";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ProcessHandlerPreBuilder {
        @NotNull
        private final Process myProcess;

        public ProcessHandlerPreBuilder(@NotNull Process process) {
            if (process == null) {
                ProcessHandlerPreBuilder.$$$reportNull$$$0(0);
            }
            this.myProcess = process;
        }

        @NotNull
        public ProcessHandlerBuilder withListener(@NotNull ProcessOutputListener listener) {
            if (listener == null) {
                ProcessHandlerPreBuilder.$$$reportNull$$$0(1);
            }
            ProcessHandlerBuilder processHandlerBuilder = new ProcessHandlerBuilder(this.myProcess, listener);
            if (processHandlerBuilder == null) {
                ProcessHandlerPreBuilder.$$$reportNull$$$0(2);
            }
            return processHandlerBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/launcher/util/process/ProcessHandler$ProcessHandlerPreBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/launcher/util/process/ProcessHandler$ProcessHandlerPreBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "withListener";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

