/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import com.jetbrains.launcher.UserMessageTransformer;
import com.jetbrains.launcher.log.Loggers;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtil {
    public static void logError(@NotNull Logger log, @NotNull Throwable e) {
        if (log == null) {
            ExceptionUtil.$$$reportNull$$$0(0);
        }
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(1);
        }
        ExceptionUtil.logError(log, null, e);
    }

    public static void logError(@NotNull Logger log, @Nullable String messagePrefix, @NotNull Throwable e) {
        if (log == null) {
            ExceptionUtil.$$$reportNull$$$0(2);
        }
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(3);
        }
        String message = ExceptionUtil.buildMessage(messagePrefix, e);
        log.error((Object)message);
        ExceptionUtil.logStackTrace(log, message, Level.ERROR, e);
    }

    public static void logWarning(@NotNull Logger log, @NotNull Throwable e) {
        if (log == null) {
            ExceptionUtil.$$$reportNull$$$0(4);
        }
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(5);
        }
        ExceptionUtil.logWarning(log, null, e);
    }

    public static void logWarning(@NotNull Logger log, @Nullable String messagePrefix, @NotNull Throwable e) {
        if (log == null) {
            ExceptionUtil.$$$reportNull$$$0(6);
        }
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(7);
        }
        String message = ExceptionUtil.buildMessage(messagePrefix, e);
        log.warn((Object)message);
        ExceptionUtil.logStackTrace(log, message, Level.WARN, e);
    }

    public static void logDebug(@NotNull Logger log, @Nullable String messagePrefix, @NotNull Throwable e) {
        if (log == null) {
            ExceptionUtil.$$$reportNull$$$0(8);
        }
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(9);
        }
        String message = ExceptionUtil.buildMessage(messagePrefix, e);
        log.debug((Object)message);
        ExceptionUtil.logStackTrace(log, message, Level.DEBUG, e);
    }

    @NotNull
    public static String buildMessage(@Nullable String messagePrefix, @NotNull Throwable e) {
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(10);
        }
        String string = UserMessageTransformer.transform((String)((messagePrefix == null ? "" : messagePrefix + ": ") + e.getMessage()));
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static void logCommandFailure(@NotNull Logger log, @NotNull String message, @Nullable Throwable e, boolean logError, boolean isUserAction) {
        if (log == null) {
            ExceptionUtil.$$$reportNull$$$0(12);
        }
        if (message == null) {
            ExceptionUtil.$$$reportNull$$$0(13);
        }
        if (logError) {
            log.error((Object)message);
        }
        if (isUserAction && e != null) {
            ExceptionUtil.logStackTrace(log, message, e);
        }
    }

    public static void logStackTrace(@NotNull Logger log, @NotNull String message, @NotNull Throwable e) {
        if (log == null) {
            ExceptionUtil.$$$reportNull$$$0(14);
        }
        if (message == null) {
            ExceptionUtil.$$$reportNull$$$0(15);
        }
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(16);
        }
        ExceptionUtil.logStackTrace(log, message, Level.ERROR, e);
    }

    public static void logStackTrace(@NotNull Logger log, @NotNull String message, @NotNull Level logLevel, @NotNull Throwable e) {
        if (log == null) {
            ExceptionUtil.$$$reportNull$$$0(17);
        }
        if (message == null) {
            ExceptionUtil.$$$reportNull$$$0(18);
        }
        if (logLevel == null) {
            ExceptionUtil.$$$reportNull$$$0(19);
        }
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(20);
        }
        if (Loggers.getLogLevel().isDebugEnabled()) {
            log.log((Priority)logLevel, (Object)message, e);
        } else {
            log.debug((Object)message, e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/ExceptionUtil";
                break;
            }
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/ExceptionUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logError";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "logWarning";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "logDebug";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildMessage";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "logCommandFailure";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "logStackTrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

