/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.configs;

import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.Resource;
import com.jetbrains.launcher.configs.AppConfig;
import com.jetbrains.launcher.configs.JvmOptionVariablesProvider;
import com.jetbrains.launcher.configs.JvmOptions;
import com.jetbrains.launcher.configs.JvmOptionsProvider;
import com.jetbrains.launcher.plugins.ExtensionHandler;
import com.jetbrains.launcher.plugins.PluginContext;
import com.jetbrains.launcher.plugins.PluginManager;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.java.InvalidJvmOptionException;
import com.jetbrains.launcher.util.java.JvmOptionsMerger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JvmOptionsReader
implements JvmOptions {
    @NotNull
    private final JvmOptionsMerger myJvmOptions;
    @NotNull
    private final AppFilesEx myAppFiles;

    public JvmOptionsReader(@NotNull AppFilesEx appFiles, @NotNull AppConfig appConfig) {
        if (appFiles == null) {
            JvmOptionsReader.$$$reportNull$$$0(0);
        }
        if (appConfig == null) {
            JvmOptionsReader.$$$reportNull$$$0(1);
        }
        this.myJvmOptions = new JvmOptionsMerger(new JvmOptionVariablesProvider((AppFiles)appFiles, appConfig).get());
        this.myAppFiles = appFiles;
    }

    @Override
    @NotNull
    public List<String> getJvmOptions() {
        List<String> list = this.myJvmOptions.getJvmOptions();
        if (list == null) {
            JvmOptionsReader.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public Map<String, String> getEnvSystemProperties() {
        Map<String, String> map = this.myJvmOptions.getEnvSystemProperties();
        if (map == null) {
            JvmOptionsReader.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public JvmOptions readAppJvmOptions(@NotNull Arguments args) throws IOException, InvalidJvmOptionException {
        if (args == null) {
            JvmOptionsReader.$$$reportNull$$$0(4);
        }
        if (args.isStartedFromService()) {
            this.myJvmOptions.addJvmOption("-Xrs");
        }
        this.loadFromResource(args.getAppFixedFiles().resolveLauncherAppConfigFile(".default.jvmoptions"));
        this.loadFromPlugins();
        this.loadFromFile(this.myAppFiles.getAppConfigFile(".jvmoptions"));
        this.myJvmOptions.addJvmOptions(args.getJvmOptions());
        JvmOptionsReader jvmOptionsReader = this;
        if (jvmOptionsReader == null) {
            JvmOptionsReader.$$$reportNull$$$0(5);
        }
        return jvmOptionsReader;
    }

    private void loadFromPlugins() throws InvalidJvmOptionException {
        PluginManager.getInstance().handleExtensions(JvmOptionsProvider.class, new ExtensionHandler<JvmOptionsProvider, InvalidJvmOptionException>(){

            @Override
            public void handle(@NotNull PluginContext context, @NotNull JvmOptionsProvider provider) throws InvalidJvmOptionException {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (provider == null) {
                    1.$$$reportNull$$$0(1);
                }
                JvmOptionsReader.this.myJvmOptions.addJvmOptions(provider.getJvmOptions(context, (AppFiles)JvmOptionsReader.this.myAppFiles));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "provider";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/launcher/configs/JvmOptionsReader$1";
                objectArray[2] = "handle";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void loadFromResource(@NotNull Resource resource) throws IOException, InvalidJvmOptionException {
        if (resource == null) {
            JvmOptionsReader.$$$reportNull$$$0(6);
        }
        if (resource.exists()) {
            this.loadFromUrl(resource.getURL());
        }
    }

    private void loadFromFile(@NotNull File file) throws IOException, InvalidJvmOptionException {
        if (file == null) {
            JvmOptionsReader.$$$reportNull$$$0(7);
        }
        if (file.isFile()) {
            this.loadFromUrl(file.toURI().toURL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromUrl(@NotNull URL url) throws IOException, InvalidJvmOptionException {
        if (url == null) {
            JvmOptionsReader.$$$reportNull$$$0(8);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(FileUtil.openStream((URL)url), "UTF-8"));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.myJvmOptions.addJvmOption(line);
            }
        }
        finally {
            FileUtil.close((Closeable)reader);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appConfig";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/configs/JvmOptionsReader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/configs/JvmOptionsReader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJvmOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvSystemProperties";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readAppJvmOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readAppJvmOptions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadFromResource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadFromFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadFromUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

