/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseCommand;
import com.jetbrains.launcher.lock.AppLockFactory;
import com.jetbrains.launcher.lock.AppState;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.ProcessUtil;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseLauncherDumpSubCommand
extends BaseCommand {
    @NotNull
    protected static final String SHORT = "short";
    @NotNull
    private final Logger LOG = Logger.getLogger(BaseLauncherDumpSubCommand.class);

    BaseLauncherDumpSubCommand() {
    }

    @Override
    @NotNull
    public String getFullName() {
        String string = "launcher dump " + this.getName();
        if (string == null) {
            BaseLauncherDumpSubCommand.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public Command.CommandType getType(@NotNull Arguments args) {
        if (args == null) {
            BaseLauncherDumpSubCommand.$$$reportNull$$$0(1);
        }
        Command.CommandType commandType = Command.CommandType.DEV_COMMAND;
        if (commandType == null) {
            BaseLauncherDumpSubCommand.$$$reportNull$$$0(2);
        }
        return commandType;
    }

    @Override
    protected void collectPossibleArgs(@NotNull Set<String> possibleArgs) {
        if (possibleArgs == null) {
            BaseLauncherDumpSubCommand.$$$reportNull$$$0(3);
        }
        possibleArgs.add(SHORT);
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) throws InitException {
        LauncherExitCode launcherExitCode;
        AppState appState;
        if (context == null) {
            BaseLauncherDumpSubCommand.$$$reportNull$$$0(4);
        }
        if ((appState = context.getAppState()) == null) {
            this.LOG.error((Object)("Cannot dump launcher " + this.getName() + ": launcher is not running"));
            LauncherExitCode launcherExitCode2 = LauncherExitCode.ILLEGAL_STATE;
            if (launcherExitCode2 == null) {
                BaseLauncherDumpSubCommand.$$$reportNull$$$0(5);
            }
            return launcherExitCode2;
        }
        Integer launcherPid = AppLockFactory.createLockChecker(context).getLauncherPid();
        if (launcherPid == null) {
            this.LOG.error((Object)"Failed to determine launcher PID");
            LauncherExitCode launcherExitCode3 = LauncherExitCode.ERROR;
            if (launcherExitCode3 == null) {
                BaseLauncherDumpSubCommand.$$$reportNull$$$0(6);
            }
            return launcherExitCode3;
        }
        try {
            ProcessUtil.ExecutionResult result = ProcessUtil.runCommand((Integer)this.getTimeoutSeconds(), (String[])this.createCmdLine(context, launcherPid));
            for (String errorLine : result.getStderr()) {
                this.LOG.error((Object)errorLine);
            }
            this.processOutput(context, result.getStdout());
            launcherExitCode = LauncherExitCode.OK;
        }
        catch (Exception e) {
            ExceptionUtil.logError((Logger)this.LOG, (String)("Failed to dump launcher " + this.getName()), (Throwable)e);
            LauncherExitCode launcherExitCode4 = LauncherExitCode.ERROR;
            if (launcherExitCode4 == null) {
                BaseLauncherDumpSubCommand.$$$reportNull$$$0(8);
            }
            return launcherExitCode4;
        }
        if (launcherExitCode == null) {
            BaseLauncherDumpSubCommand.$$$reportNull$$$0(7);
        }
        return launcherExitCode;
    }

    @Nullable
    protected abstract Integer getTimeoutSeconds();

    @NotNull
    protected abstract String[] createCmdLine(@NotNull LauncherContextEx var1, int var2) throws IOException;

    protected abstract void processOutput(@NotNull LauncherContextEx var1, @NotNull List<String> var2) throws IOException;

    protected static boolean isShort(@NotNull Arguments args) {
        if (args == null) {
            BaseLauncherDumpSubCommand.$$$reportNull$$$0(9);
        }
        return args.containsLauncherParam(SHORT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/BaseLauncherDumpSubCommand";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleArgs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/BaseLauncherDumpSubCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectPossibleArgs";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isShort";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

