/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.ProcessEnvironment;
import com.jetbrains.launcher.ep.commands.BaseCommand;
import com.jetbrains.launcher.log.LoggerMode;
import com.jetbrains.launcher.util.LauncherUtil;
import com.jetbrains.launcher.util.process.ProcessHandler;
import com.jetbrains.launcher.util.process.ProcessUtilEx;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseProcessBasedCommand
extends BaseCommand {
    @NotNull
    private final Logger LOG = Logger.getLogger(BaseProcessBasedCommand.class);

    @Override
    @NotNull
    protected LoggerMode getLoggerMode(@NotNull Arguments args) {
        if (args == null) {
            BaseProcessBasedCommand.$$$reportNull$$$0(0);
        }
        LoggerMode loggerMode = LoggerMode.LAUNCHER;
        if (loggerMode == null) {
            BaseProcessBasedCommand.$$$reportNull$$$0(1);
        }
        return loggerMode;
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) throws InitException {
        List<String> cmdLine;
        if (context == null) {
            BaseProcessBasedCommand.$$$reportNull$$$0(2);
        }
        if ((cmdLine = this.buildProcessCmdLine(context)) != null) {
            LauncherExitCode launcherExitCode = BaseProcessBasedCommand.runProcess(context.getAppFiles().getAppHome(), cmdLine, false, this.LOG, this.createExitCodeConverter());
            if (launcherExitCode == null) {
                BaseProcessBasedCommand.$$$reportNull$$$0(3);
            }
            return launcherExitCode;
        }
        LauncherExitCode launcherExitCode = LauncherExitCode.OK;
        if (launcherExitCode == null) {
            BaseProcessBasedCommand.$$$reportNull$$$0(4);
        }
        return launcherExitCode;
    }

    @NotNull
    protected abstract ExitCodeConverter createExitCodeConverter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected static LauncherExitCode runProcess(@NotNull File workDir, @NotNull List<String> cmdLine, boolean debug, @NotNull Logger log, @NotNull ExitCodeConverter exitCodeConverter) {
        LauncherExitCode launcherExitCode;
        Process process;
        if (workDir == null) {
            BaseProcessBasedCommand.$$$reportNull$$$0(5);
        }
        if (cmdLine == null) {
            BaseProcessBasedCommand.$$$reportNull$$$0(6);
        }
        if (log == null) {
            BaseProcessBasedCommand.$$$reportNull$$$0(7);
        }
        if (exitCodeConverter == null) {
            BaseProcessBasedCommand.$$$reportNull$$$0(8);
        }
        log.debug((Object)("Starting process: " + cmdLine + " (at path: " + workDir.getAbsolutePath() + ")"));
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(cmdLine).directory(workDir);
            processBuilder.environment().putAll(ProcessEnvironment.getOwn());
            process = processBuilder.start();
        }
        catch (IOException e) {
            log.error((Object)("Failed to execute command \"" + cmdLine + "\": " + e.getMessage()));
            LauncherExitCode launcherExitCode2 = LauncherExitCode.ERROR;
            if (launcherExitCode2 == null) {
                BaseProcessBasedCommand.$$$reportNull$$$0(9);
            }
            return launcherExitCode2;
        }
        String processLogPrefix = LauncherUtil.getProcessLogPrefix(cmdLine);
        ProcessHandler processHandler = ProcessUtilEx.toLog(ProcessHandler.builder((Process)process), log, debug).withPrefix(processLogPrefix).build();
        processHandler.start();
        try {
            LauncherExitCode launcherExitCode3 = exitCodeConverter.toLauncherExitCode(process.waitFor());
            launcherExitCode = launcherExitCode3;
        }
        catch (InterruptedException e) {
            log.warn((Object)"Process interrupted");
            LauncherExitCode launcherExitCode4 = LauncherExitCode.ERROR;
            LauncherExitCode launcherExitCode5 = launcherExitCode4;
            if (launcherExitCode5 == null) {
                BaseProcessBasedCommand.$$$reportNull$$$0(11);
            }
            return launcherExitCode5;
        }
        finally {
            processHandler.finish();
        }
        if (launcherExitCode == null) {
            BaseProcessBasedCommand.$$$reportNull$$$0(10);
        }
        return launcherExitCode;
    }

    @Nullable
    protected abstract List<String> buildProcessCmdLine(@NotNull LauncherContext var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/BaseProcessBasedCommand";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exitCodeConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/BaseProcessBasedCommand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerMode";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerMode";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface ExitCodeConverter {
        @NotNull
        public static final ExitCodeConverter DEFAULT = new ExitCodeConverter(){

            @Override
            @NotNull
            public LauncherExitCode toLauncherExitCode(int exitCode) {
                LauncherExitCode launcherExitCode = exitCode == 0 ? LauncherExitCode.OK : LauncherExitCode.ERROR;
                if (launcherExitCode == null) {
                    1.$$$reportNull$$$0(0);
                }
                return launcherExitCode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/ep/commands/BaseProcessBasedCommand$ExitCodeConverter$1", "toLauncherExitCode"));
            }
        };

        @NotNull
        public LauncherExitCode toLauncherExitCode(int var1);
    }
}

