/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseDumpSubCommand;
import com.jetbrains.launcher.log.ConsoleLogger;
import com.jetbrains.launcher.log.LoggerMode;
import com.jetbrains.launcher.run.AgentDiagnosticFacade;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DumpThreads
extends BaseDumpSubCommand {
    @NotNull
    public static final String NAME = "threads";
    @NotNull
    private static final String TO_FILE = "to-file";

    @NotNull
    public String getName() {
        if (NAME == null) {
            DumpThreads.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    protected void collectPossibleArgs(@NotNull Set<String> possibleArgs) {
        if (possibleArgs == null) {
            DumpThreads.$$$reportNull$$$0(1);
        }
        super.collectPossibleArgs(possibleArgs);
        possibleArgs.add(TO_FILE);
    }

    @Override
    @NotNull
    protected LoggerMode getLoggerMode(@NotNull Arguments args) {
        if (args == null) {
            DumpThreads.$$$reportNull$$$0(2);
        }
        LoggerMode loggerMode = !DumpThreads.isToFile(args) || DumpThreads.isShort(args) ? LoggerMode.CONSOLE_ERROR_ONLY : LoggerMode.CONSOLE_ONLY;
        if (loggerMode == null) {
            DumpThreads.$$$reportNull$$$0(3);
        }
        return loggerMode;
    }

    @Override
    protected void dump(@NotNull Arguments args, @NotNull AgentDiagnosticFacade diagnosticFacade) throws IOException {
        if (args == null) {
            DumpThreads.$$$reportNull$$$0(4);
        }
        if (diagnosticFacade == null) {
            DumpThreads.$$$reportNull$$$0(5);
        }
        if (DumpThreads.isToFile(args)) {
            File file = diagnosticFacade.dumpThreadsToFile();
            if (DumpThreads.isShort(args)) {
                ConsoleLogger.system((String)file.getAbsolutePath());
            } else {
                ConsoleLogger.info((String)("Threads were dumped to the file: " + file.getAbsolutePath()));
            }
        } else {
            ConsoleLogger.system((String)diagnosticFacade.dumpThreads());
        }
    }

    private static boolean isToFile(@NotNull Arguments args) {
        if (args == null) {
            DumpThreads.$$$reportNull$$$0(6);
        }
        return args.containsLauncherParam(TO_FILE);
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            DumpThreads.$$$reportNull$$$0(7);
        }
        if (context == null) {
            DumpThreads.$$$reportNull$$$0(8);
        }
        printer.print(this.getFullName(), "dumps " + context.getAppConfig().getAppName().getName() + " threads, " + this.getComplexCommandUsageText());
    }

    @Override
    public void printStandaloneUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            DumpThreads.$$$reportNull$$$0(9);
        }
        if (context == null) {
            DumpThreads.$$$reportNull$$$0(10);
        }
        String name = context.getAppConfig().getAppName().getName();
        printer.print(this.getFullName(), "dumps " + name + " threads to the console");
        String toFileCommand = this.getFullName() + " " + TO_FILE;
        printer.print(toFileCommand, "dumps " + name + " threads to the file under the logs directory");
        printer.print(toFileCommand + " " + "short", "same as \"" + toFileCommand + "\", but prints to the console nothing but the absolute path of the created file");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/DumpThreads";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleArgs";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnosticFacade";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/DumpThreads";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerMode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectPossibleArgs";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerMode";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dump";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isToFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "printStandaloneUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

