/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.run;

import com.jetbrains.launcher.Status;
import com.jetbrains.launcher.log.ConsoleLogger;
import com.jetbrains.launcher.run.AgentStatusWatcher;
import com.jetbrains.launcher.run.UpToDateLauncherContext;
import com.jetbrains.launcher.util.AsyncWaitFor;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AgentStatusWatcherImpl
extends AsyncWaitFor
implements AgentStatusWatcher {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final UpToDateLauncherContext myContext;
    private final boolean myMustLogMarker;
    private volatile boolean myWasRunning;

    public AgentStatusWatcherImpl(@NotNull UpToDateLauncherContext context, boolean mustLogMarker) {
        if (context == null) {
            AgentStatusWatcherImpl.$$$reportNull$$$0(0);
        }
        super(context.getAppConfig().getAppName().getCapitalizedName() + " Status Watcher");
        this.LOG = Logger.getLogger(AgentStatusWatcherImpl.class);
        this.myWasRunning = false;
        this.myContext = context;
        this.myMustLogMarker = mustLogMarker;
        this.start();
    }

    protected boolean condition() {
        return this.myContext.createAgentFacade().getStatus().is(Status.RUNNING);
    }

    protected void performAction() {
        this.myWasRunning = true;
        if (this.myMustLogMarker) {
            ConsoleLogger.system((String)"###-STARTED-f0SJK3P4wGKm6dOdWlouxGHLBO5Pogsbq27V7h9M-###");
            this.LOG.debug((Object)"Service started status marker printed to console");
        }
    }

    @Override
    public boolean wasRunning() {
        return this.myWasRunning;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/launcher/run/AgentStatusWatcherImpl", "<init>"));
    }
}

