/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.PropertiesProvider;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.service.util.BundleEnvironmentProperty;
import java.nio.file.Path;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class BundleEnvironmentPropertiesProvider
implements PropertiesProvider {
    private final BundleEnvironment myBundleEnvironment;

    public BundleEnvironmentPropertiesProvider(BundleEnvironment bundleEnvironment) {
        this.myBundleEnvironment = bundleEnvironment;
    }

    @Override
    public void addToServiceProperties(@NotNull ServiceDescriptor descriptor, @NotNull Properties serviceProperties) {
        Path bundleConfigPath = this.myBundleEnvironment.getConfDir();
        serviceProperties.setProperty(BundleEnvironmentProperty.CONF_DIR.getPrefixedName(), bundleConfigPath.toString());
        serviceProperties.setProperty(BundleEnvironmentProperty.INSTALLATION_TYPE.getPrefixedName(), this.myBundleEnvironment.getInstallationConfig().getInstallationType().name());
    }
}

