/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.bundle.BundleBuildProperties;
import com.jetbrains.bundle.BundleConsoleLogger;
import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.BundleInstallationType;
import com.jetbrains.bundle.BundleProperties;
import com.jetbrains.bundle.BundleState;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.ServiceDiscovery;
import com.jetbrains.bundle.ServicesConfiguration;
import com.jetbrains.bundle.UpgradeProperties;
import com.jetbrains.bundle.api.internal.services.ServicesInformationProvider;
import com.jetbrains.bundle.api.internal.services.impl.ServicesInformationProviderImpl;
import com.jetbrains.bundle.api.internal.services.model.ProductState;
import com.jetbrains.bundle.api.internal.services.model.ServiceInfo;
import com.jetbrains.bundle.api.internal.services.model.ServiceStatus;
import com.jetbrains.bundle.exceptions.RequiringShutdownException;
import com.jetbrains.bundle.exceptions.ServicesAlreadyStartedException;
import com.jetbrains.bundle.gzip.GzipSettings;
import com.jetbrains.bundle.launcher.context.holder.ApplicationContextHolder;
import com.jetbrains.bundle.listener.BundleListener;
import com.jetbrains.bundle.listener.event.ServiceStartedEvent;
import com.jetbrains.bundle.proxy.jetty.BundleProxy;
import com.jetbrains.bundle.services.Service;
import com.jetbrains.bundle.services.ServicesContainer;
import com.jetbrains.bundle.services.ServicesHolder;
import com.jetbrains.bundle.services.impl.AdminConsoleService;
import com.jetbrains.bundle.services.impl.BundleBackendService;
import com.jetbrains.bundle.services.impl.BundledCliService;
import com.jetbrains.bundle.services.impl.BundledInternalService;
import com.jetbrains.bundle.services.impl.CliService;
import com.jetbrains.bundle.services.impl.HubConfiguratorService;
import com.jetbrains.bundle.services.impl.InProcessJettyService;
import com.jetbrains.bundle.services.impl.ServiceBase;
import com.jetbrains.bundle.services.impl.jetty.BundleJettyServicesContainer;
import com.jetbrains.bundle.util.BrowserUtil;
import com.jetbrains.bundle.wizard.ConfigurationWizard;
import com.jetbrains.bundle.wizard.WizardConfiguredProperties;
import com.jetbrains.launcher.AppExitCode;
import com.jetbrains.launcher.StartKind;
import com.jetbrains.launcher.Status;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.launcher.exceptions.StartupException;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.ServiceProperties;
import com.jetbrains.service.util.StatusException;
import com.jetbrains.service.util.SystemUtil;
import com.jetbrains.service.util.UrlUtil;
import com.jetbrains.service.util.cmd.ExecuteServiceCommandException;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Services
implements ServicesInformationProvider {
    private static final List<Locale> DEFAULT_SUPPORTED_LOCALES = Collections.singletonList(Locale.forLanguageTag("en-US"));
    private final ServicesConfiguration myServicesConfiguration;
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    public static final String STARTING_PAGE_CONTEXT = "/bundle/starting";
    private final ServicesHolder myServicesHolder;
    private final List<BundleListener<ServiceStartedEvent>> myServiceStartedListeners = new ArrayList<BundleListener<ServiceStartedEvent>>();
    private final ServiceStatusResolver myServiceStatusResolver;
    @NotNull
    private final ServiceDescriptor myServiceForRedirectionAfterStart;
    private static final int STATUS_MESSAGE_MAX_LENGTH_IN_CHARS = Integer.getInteger("jetbrains.ring.max.service.status.message.length", 16384);
    private static final List<String> CHECKED_FOLDERS_PROPERTY_NAMES = Collections.unmodifiableList(Arrays.asList(ServiceProperties.LOGS_DIR_PROPERTY, ServiceProperties.DATA_DIR_PROPERTY, ServiceProperties.BACKUPS_DIR_PROPERTY, ServiceProperties.TEMP_DIR_PROPERTY));
    private volatile StartingState myStartingState = new StartingState();
    private final Object stopServiceMonitor = new Object();

    public Services(List<ServiceDescriptor> serviceDescriptors, ServicesConfiguration servicesConfiguration) {
        this.myServicesConfiguration = servicesConfiguration;
        Set<String> allBundleServiceContainers = this.myServicesConfiguration.getBundleState().getBuildProperties().getAllBundledServiceContainers();
        this.myServicesHolder = new ServicesHolder(serviceDescriptors);
        this.myServiceStatusResolver = new ServiceStatusResolver(this.myServicesHolder);
        this.myServiceForRedirectionAfterStart = this.getAfterStartService();
        Map<String, ServiceDescriptor> allBundleServices = Services.getBundleServices(this.myServicesConfiguration.getBundleState());
        ApplicationContextHolder contextHolder = this.myServicesConfiguration.getBundleState().getContextHolder();
        for (ServiceDescriptor descriptor : this.myServicesHolder.getSortedServiceDescriptors()) {
            ServiceBase service;
            if ("bundle-hub-configurator".equals(descriptor.getId())) {
                service = new HubConfiguratorService(descriptor, this.myServicesConfiguration.getBundleState().getEnvironment(), contextHolder);
            } else if ("bundleProcess".equals(descriptor.getId())) {
                BundleProxy bundleProxy = new BundleProxy(this.myServicesHolder, this.myServicesConfiguration.getBundleState());
                service = new InProcessJettyService<BundleProxy>(bundleProxy, descriptor, this.myServicesConfiguration.getBundleState());
                this.myServiceStartedListeners.add(bundleProxy.new BundleProxy.AddProxyOnServiceStartedListener());
            } else if (allBundleServiceContainers.contains(descriptor.getId())) {
                service = new InProcessJettyService<BundleJettyServicesContainer>(new BundleJettyServicesContainer(this.myServicesHolder, contextHolder), descriptor, this.myServicesConfiguration.getBundleState());
            } else if (this.myServicesConfiguration.isBundledService(descriptor.getId())) {
                String hostingServletContainerServiceId = this.myServicesConfiguration.getBundleState().getBuildProperties().getBundledServices().get(descriptor.getId());
                InProcessJettyService hostingServletContainer = (InProcessJettyService)this.myServicesHolder.getNotNullService(hostingServletContainerServiceId);
                String serviceStatusURL = this.getServiceStatusUrl(descriptor);
                if ("adminService".equals(descriptor.getId())) {
                    service = new AdminConsoleService(descriptor, serviceStatusURL, this.myServicesConfiguration.getBundleState().getEnvironment(), this.myServicesConfiguration.getBundleState(), (ServicesContainer)hostingServletContainer.getWrappedService(), this, this.myServiceForRedirectionAfterStart);
                } else if ("configurationWizard".equals(descriptor.getId())) {
                    List<Locale> supportedLocales = Services.getSupportedLocales(allBundleServices);
                    ServiceDescriptor serviceForRedirectionAfterWizard = Services.getAfterStartService(this.myServicesConfiguration.getBundleState().getBuildProperties(), allBundleServices);
                    service = new ConfigurationWizard(descriptor, this.myServicesConfiguration.getBundleState(), serviceForRedirectionAfterWizard, supportedLocales, allBundleServices, serviceStatusURL, (ServicesContainer)hostingServletContainer.getWrappedService());
                } else {
                    service = "bundleBackend".equals(descriptor.getId()) ? new BundleBackendService(descriptor, serviceStatusURL, this.myServicesConfiguration.getBundleState(), (ServicesContainer)hostingServletContainer.getWrappedService()) : (descriptor.isInternal() ? new BundledInternalService(descriptor, serviceStatusURL, this.myServicesConfiguration.getBundleState().getEnvironment(), (ServicesContainer)hostingServletContainer.getWrappedService(), contextHolder) : new BundledCliService(descriptor, serviceStatusURL, (ServicesContainer)hostingServletContainer.getWrappedService(), contextHolder));
                }
            } else {
                service = new CliService(descriptor, contextHolder);
            }
            this.myServicesHolder.addService(service);
        }
        this.myServiceStartedListeners.add(new UpgradeProperties.ServiceStartedListener());
    }

    @NotNull
    static Services createServices(@NotNull BundleState bundleState) {
        List<ServiceDescriptor> actualServiceDescriptors;
        WizardConfiguredProperties wizardConfiguredProperties = new WizardConfiguredProperties(bundleState.getEnvironment());
        if (wizardConfiguredProperties.isConfigured(bundleState)) {
            Map<String, ServiceDescriptor> allProductServiceDescriptors = Services.getBundleServices(bundleState);
            actualServiceDescriptors = new ArrayList<ServiceDescriptor>(allProductServiceDescriptors.values());
        } else {
            Path serviceContainerHomePath = bundleState.getEnvironment().getBundleHomeInternal().resolve("bundleProcess");
            actualServiceDescriptors = Arrays.asList(Services.createServiceContainerDescriptor(serviceContainerHomePath, "bundleProcess", bundleState.getBuildProperties()), Services.createConfigurationWizardDescriptor(bundleState.getEnvironment().getBundleHomeInternal().resolve("wizard_web"), bundleState), Services.createBundleBackendServiceDescriptor(bundleState.getEnvironment(), bundleState.getBuildProperties()));
        }
        ServicesConfiguration servicesConfiguration = new ServicesConfiguration(actualServiceDescriptors, bundleState);
        return new Services(actualServiceDescriptors, servicesConfiguration);
    }

    @NotNull
    static Map<String, ServiceDescriptor> getBundleServices(BundleState bundleState) {
        return Services.getBundleServices(bundleState, true);
    }

    @NotNull
    public static Map<String, ServiceDescriptor> getBundleServices(BundleState bundleState, boolean skipDisabled) {
        Map<String, ServiceDescriptor> resultBundleServices;
        BundleEnvironment environment = bundleState.getEnvironment();
        BundleBuildProperties bundleBuildProperties = bundleState.getBuildProperties();
        ServiceDiscovery serviceDiscovery = new ServiceDiscovery(bundleState);
        Map<String, ServiceDescriptor> allProductServiceDescriptors = serviceDiscovery.discoverServices();
        if (skipDisabled) {
            resultBundleServices = new HashMap<String, ServiceDescriptor>();
            for (String string : allProductServiceDescriptors.keySet()) {
                if (!bundleState.getProperties().isServiceEnabled(string)) continue;
                resultBundleServices.put(string, allProductServiceDescriptors.get(string));
            }
        } else {
            resultBundleServices = allProductServiceDescriptors;
        }
        Set<String> serviceContainers = bundleBuildProperties.getAllBundledServiceContainers();
        serviceContainers.add("bundleProcess");
        for (String serviceContainerId : serviceContainers) {
            Path serviceContainerHomePath = environment.getBundleHomeInternal().resolve(serviceContainerId);
            ServiceDescriptor serviceContainerDescriptor = Services.createServiceContainerDescriptor(serviceContainerHomePath, serviceContainerId, bundleBuildProperties);
            resultBundleServices.put(serviceContainerDescriptor.getId(), serviceContainerDescriptor);
        }
        if (!skipDisabled || bundleState.getProperties().isServiceEnabled("adminService")) {
            ServiceDescriptor serviceDescriptor = Services.createAdminConsoleServiceDescriptor(environment.getBundleHomeInternal().resolve("admin_console"), bundleBuildProperties);
            resultBundleServices.put(serviceDescriptor.getId(), serviceDescriptor);
        }
        if (!skipDisabled || bundleState.getProperties().isServiceEnabled("bundleBackend")) {
            ServiceDescriptor serviceDescriptor = Services.createBundleBackendServiceDescriptor(environment, bundleBuildProperties);
            resultBundleServices.put(serviceDescriptor.getId(), serviceDescriptor);
        }
        if (allProductServiceDescriptors.keySet().contains("hub")) {
            ServiceDescriptor serviceDescriptor = Services.createHubConfiguratorServiceDescriptor(environment.getBundleHomeInternal().resolve("hubConfigurator"), bundleBuildProperties);
            resultBundleServices.put(serviceDescriptor.getId(), serviceDescriptor);
        }
        if (!skipDisabled || bundleState.getProperties().isServiceEnabled("startingPage")) {
            ServiceDescriptor serviceDescriptor = Services.createStartingPageServiceDescriptor(environment.getBundleHomeInternal().resolve("starting_page"), bundleBuildProperties);
            resultBundleServices.put(serviceDescriptor.getId(), serviceDescriptor);
        }
        return resultBundleServices;
    }

    private static ServiceDescriptor createConfigurationWizardDescriptor(Path path, BundleState bundleState) {
        return Services.createInternalServiceDescriptor(path, "configurationWizard", "Configuration Wizard", Collections.emptyList(), Collections.emptyList(), "/", "api/wizard/status", false, true, bundleState.getBuildProperties(), true);
    }

    private static ServiceDescriptor createServiceContainerDescriptor(Path path, String serviceContainerId, BundleBuildProperties bundleBuildProperties) {
        Collection<String> bundledServices = bundleBuildProperties.getServicesBundledIn(serviceContainerId);
        ArrayList<String> runBeforeList = new ArrayList<String>(bundledServices);
        ArrayList<String> runAfterList = new ArrayList<String>();
        if (!"bundleProcess".equals(serviceContainerId)) {
            runAfterList.add("bundleProcess");
        }
        return Services.createInternalServiceDescriptor(path, serviceContainerId, "Service-Container[" + serviceContainerId + "]", runAfterList, runBeforeList, "/", null, false, false, bundleBuildProperties, false, true);
    }

    private static ServiceDescriptor createAdminConsoleServiceDescriptor(Path path, BundleBuildProperties bundleBuildProperties) {
        ArrayList<String> runAfterList = new ArrayList<String>();
        runAfterList.add("startingPage");
        runAfterList.add("bundleProcess");
        return Services.createInternalServiceDescriptor(path, "adminService", bundleBuildProperties.getBundleProductName() + " Configurator", runAfterList, Collections.emptyList(), "/bundle/admin", "/", false, true, bundleBuildProperties, true);
    }

    private static ServiceDescriptor createBundleBackendServiceDescriptor(BundleEnvironment bundleEnvironment, BundleBuildProperties bundleBuildProperties) {
        ArrayList<String> runAfterList = new ArrayList<String>();
        runAfterList.add("bundleProcess");
        ArrayList<String> runBeforeList = new ArrayList<String>();
        runBeforeList.add("startingPage");
        return Services.createInternalServiceDescriptor(bundleEnvironment.getBundleHomeInternal().resolve("bundle_common"), "bundleBackend", "Bundle Backend Service", runAfterList, runBeforeList, "/bundle/backend", "/api/bundleBackendStatus", false, true, bundleBuildProperties, false);
    }

    private static ServiceDescriptor createHubConfiguratorServiceDescriptor(@NotNull Path path, @NotNull BundleBuildProperties bundleBuildProperties) {
        ArrayList<String> runAfterList = new ArrayList<String>();
        runAfterList.add("hub");
        return Services.createInternalServiceDescriptor(path, "bundle-hub-configurator", "Bundle Hub Configurator", runAfterList, Collections.emptyList(), "/bundle/hub-configurator", "/", false, false, bundleBuildProperties, false);
    }

    private static ServiceDescriptor createStartingPageServiceDescriptor(Path path, BundleBuildProperties bundleBuildProperties) {
        return Services.createInternalServiceDescriptor(path, "startingPage", "Starting Page Service", Collections.emptyList(), Collections.emptyList(), STARTING_PAGE_CONTEXT, "api/bundle/startingPageStatus", false, true, bundleBuildProperties, true);
    }

    private static ServiceDescriptor createInternalServiceDescriptor(@NotNull Path path, @NotNull String serviceId, @NotNull String servicePresentableName, @NotNull List<String> runAfterServices, @NotNull List<String> runBeforeServices, String context, String statusPageContextPath, boolean parentFirstClassLoading, @NotNull Boolean isAnnotationBased, @NotNull BundleBuildProperties bundleBuildProperties, boolean isWebApp) {
        return Services.createInternalServiceDescriptor(path, serviceId, servicePresentableName, runAfterServices, runBeforeServices, context, statusPageContextPath, parentFirstClassLoading, isAnnotationBased, bundleBuildProperties, isWebApp, false);
    }

    private static ServiceDescriptor createInternalServiceDescriptor(final @NotNull Path path, final @NotNull String serviceId, final @NotNull String servicePresentableName, final @NotNull List<String> runAfterServices, final @NotNull List<String> runBeforeServices, final String context, final String statusPageContextPath, final boolean parentFirstClassLoading, final @NotNull Boolean isAnnotationBased, final @NotNull BundleBuildProperties bundleBuildProperties, final boolean isWebApp, final boolean isBundleServiceContainer) {
        return new ServiceDescriptor(){

            @Override
            @NotNull
            public String getId() {
                return serviceId;
            }

            @Override
            @NotNull
            public String getPresentableName() {
                return servicePresentableName;
            }

            @Override
            @NotNull
            public Path getFullPath() {
                return path;
            }

            @Override
            public boolean isHubService() {
                return false;
            }

            @Override
            @NotNull
            public String getHubServiceName() {
                return this.getId();
            }

            @Override
            public String getHubServiceBelongsTo() {
                return null;
            }

            @Override
            @NotNull
            public List<String> getRunAfterServices() {
                return runAfterServices;
            }

            @Override
            @NotNull
            public List<String> getRunBeforeServices() {
                return runBeforeServices;
            }

            @Override
            @NotNull
            public List<String> getStartCommand() {
                throw new UnsupportedOperationException("It is not possible to start service [" + servicePresentableName + "] with help of command");
            }

            @Override
            @NotNull
            public List<String> getStopCommand() {
                throw new UnsupportedOperationException("It is not possible to stop service [" + servicePresentableName + "] with help of command");
            }

            @Override
            @NotNull
            public List<String> getStatusCommand() {
                throw new UnsupportedOperationException("It is not possible to get status of service [" + servicePresentableName + "] with help of command");
            }

            @Override
            @NotNull
            public List<String> getConfigureCommand() {
                throw new UnsupportedOperationException("It is not possible to configure service [" + servicePresentableName + "] with help of command");
            }

            @Override
            @NotNull
            public List<String> getListCommand() {
                throw new UnsupportedOperationException("It is not possible to call list command for service [" + servicePresentableName + "]");
            }

            @Override
            @NotNull
            public String getContext() {
                return context;
            }

            @Override
            public String getBeforeStartCallbackClass() {
                return null;
            }

            @Override
            public String getFirstMajorReleaseDate() {
                return null;
            }

            @Override
            public String getAfterStartCallbackClass() {
                return null;
            }

            @Override
            public String getStatusPageContextPath() {
                return statusPageContextPath;
            }

            @Override
            public boolean isParentFirstClassLoading() {
                return parentFirstClassLoading;
            }

            @Override
            public boolean isAnnotationBased() {
                return isAnnotationBased;
            }

            @Override
            public boolean isInternal() {
                return true;
            }

            @Override
            @NotNull
            public Collection<Locale> getSupportedLocales() {
                return Collections.emptyList();
            }

            @Override
            @Nullable
            public String getHubApplicationName() {
                return this.getId();
            }

            @Override
            @NotNull
            public Collection<String> getAdditionalRedirectUris() {
                return Collections.emptyList();
            }

            @Override
            @NotNull
            public String getVersion() {
                String version = bundleBuildProperties.getBundleVersion();
                return version != null ? version : "unknown";
            }

            @Override
            @NotNull
            public String getManufacturer() {
                return bundleBuildProperties.getBundleProductManufacturer();
            }

            @Override
            public boolean isWebApp() {
                return isWebApp;
            }

            @Override
            public boolean isBundleServiceContainer() {
                return isBundleServiceContainer;
            }

            @Override
            public File getLicenseAgreementFile() {
                return null;
            }

            @Override
            public String getLicenseAgreementProductName() {
                return null;
            }

            @Override
            public String getLicenseUserName() {
                return null;
            }

            @Override
            public String getLicenseKey() {
                return null;
            }

            @Override
            @Nullable
            public GzipSettings getGzipSettings() {
                return null;
            }
        };
    }

    private String getServiceStatusUrl(@NotNull ServiceDescriptor descriptor) {
        Properties serviceConfiguration = this.myServicesConfiguration.getServiceConfiguration(descriptor);
        return UrlUtil.ensureEndsWithSlash((String)PropertiesBasedConfigurationHelper.getHelper().getServiceInternalBaseUrl((Object)serviceConfiguration, descriptor.getId())) + UrlUtil.ensureStartsWithoutSlash((String)serviceConfiguration.getProperty("status-page-context-path"));
    }

    public Properties calculateServiceConfiguration(@NotNull ServiceDescriptor descriptor) {
        return this.myServicesConfiguration.getServiceConfiguration(descriptor);
    }

    @NotNull
    public Map<String, ServiceDescriptor> getServiceDescriptorsMap() {
        HashMap<String, ServiceDescriptor> descriptors = new HashMap<String, ServiceDescriptor>();
        for (ServiceDescriptor serviceDescriptor : this.myServicesHolder.getSortedServiceDescriptors()) {
            descriptors.put(serviceDescriptor.getId(), serviceDescriptor);
        }
        return descriptors;
    }

    @NotNull
    public Service findService(String id) {
        ServiceBase service = this.myServicesHolder.getService(id);
        if (service == null) {
            throw new IllegalStateException("Service with id [" + id + "] is not found");
        }
        return service;
    }

    public void start(boolean fromLauncher) {
        ServicesInformationProviderImpl.setProvider(this);
        Exception startingException = null;
        try {
            this.myStartingState.beginStarting();
            this.startAllServices(fromLauncher);
        }
        catch (Exception e) {
            startingException = e;
            String errorMessage = "Error while starting " + this.myServicesConfiguration.getBundleState().getBuildProperties().getBundlePresentationName() + ": " + e.getMessage();
            BundleConsoleLogger.get().error(errorMessage);
            throw new RequiringShutdownException(errorMessage, (Throwable)e, AppExitCode.EXIT, false);
        }
        finally {
            if (startingException == null) {
                this.myStartingState.finishStarting();
            }
        }
    }

    private void startAllServices(boolean fromLauncher) throws StartupException {
        for (ServiceBase service : this.myServicesHolder.getSortedServices()) {
            BundleConsoleLogger.get().info(String.format("Starting %s", service.getDescriptor().getPresentableName()));
            if (!this.myServiceForRedirectionAfterStart.getId().equals(service.getDescriptor().getId())) {
                this.startService(service);
                continue;
            }
            String urlToShow = this.getAndLogToConsoleUrlToShowAfterStart(service);
            this.startService(service);
            ApplicationContextHolder appContextHolder = this.myServicesConfiguration.getBundleState().getContextHolder();
            if (!fromLauncher || StartKind.RESTART_AFTER_CRASH == appContextHolder.getStartKind() || StartKind.REQUESTED_RESTART == appContextHolder.getStartKind() && (appContextHolder.getRestartState() == null || !Boolean.valueOf(appContextHolder.getRestartState().get(ApplicationContextHolder.RestartParameters.openBrowserOnStartUp.name())).booleanValue()) || appContextHolder.getArgs().contains("--no-browser") || appContextHolder.isService() || BundleInstallationType.DOCKER == this.myServicesConfiguration.getBundleState().getEnvironment().getInstallationConfig().getInstallationType()) continue;
            BrowserUtil.tryOpenInBrowser(urlToShow);
        }
    }

    @NotNull
    private String getAndLogToConsoleUrlToShowAfterStart(@NotNull ServiceBase service) {
        String urlMessage;
        String urlToShow;
        String afterStartServicePresentationName = this.myServicesConfiguration.getBundleState().getBuildProperties().getBundlePresentationName() + (service.getDescriptor().getId().equals("configurationWizard") ? " Configuration Wizard" : "");
        BundleInstallationType installationType = this.myServicesConfiguration.getBundleState().getEnvironment().getInstallationConfig().getInstallationType();
        if (BundleInstallationType.DOCKER == installationType && this.myServicesConfiguration.getBundleProperties().isDefaultBaseUrl()) {
            String fullServiceUrlPath = this.myServicesConfiguration.getBundleProperties().getFullServiceUrlPath(service.getDescriptor());
            urlToShow = this.addWizardTokenIfNeeded(service, UrlUtil.combineUrls((String)String.format("http://<put-your-docker-HOST-name-here>:<put-host-port-mapped-to-container-port-%s-here>", this.myServicesConfiguration.getBundleProperties().getListenPort()), (String)fullServiceUrlPath));
            urlMessage = String.format("%s will listen inside container on {%s:%s}%s after start and can be accessed by URL [%s]", afterStartServicePresentationName, this.myServicesConfiguration.getBundleProperties().getListenAddress(), this.myServicesConfiguration.getBundleProperties().getListenPort(), fullServiceUrlPath, urlToShow);
        } else {
            urlToShow = this.addWizardTokenIfNeeded(service, this.myServicesConfiguration.getBundleState().getProperties().getServiceUrl(service.getDescriptor()));
            urlMessage = String.format("%s will be available on [%s] after start", afterStartServicePresentationName, urlToShow);
        }
        BundleConsoleLogger.get().info(urlMessage);
        return urlToShow;
    }

    private String addWizardTokenIfNeeded(@NotNull ServiceBase service, @NotNull String urlToShow) {
        return service instanceof ConfigurationWizard ? urlToShow.concat("?wizard_token=").concat(((ConfigurationWizard)service).getWizardToken()) : urlToShow;
    }

    private void startService(Service service) throws StartupException {
        Throwable startException = null;
        this.myStartingState.updateServiceState(service.getDescriptor().getId(), Status.STARTING);
        try {
            service.start();
        }
        catch (StartupException | RuntimeException e) {
            startException = e;
            this.myStartingState.updateServiceState(service.getDescriptor().getId(), Status.ERROR, this.constructStatusMessage((Exception)e));
            throw e;
        }
        finally {
            this.onServiceStarted(service.getDescriptor(), startException);
        }
        this.myStartingState.updateServiceState(service.getDescriptor().getId(), Status.RUNNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopService(@NotNull Service service, boolean force, @NotNull AppExitCode appExitCode) {
        boolean shuttingDownStatusIsSet = false;
        while (!shuttingDownStatusIsSet) {
            try {
                this.myStartingState.updateServiceState(service.getDescriptor().getId(), Status.SHUTTING_DOWN);
                shuttingDownStatusIsSet = true;
            }
            catch (Exception e) {
                this.LOG.debug(String.format("Can not set status [%s] to service [%s] due to error: %s", Status.SHUTTING_DOWN, service.getDescriptor().getId(), e.getMessage()));
                Object object = this.stopServiceMonitor;
                synchronized (object) {
                    try {
                        this.stopServiceMonitor.wait(200L);
                    }
                    catch (InterruptedException ie) {
                        throw new IllegalStateException("Shut down has not been executed due to occurred exception: " + ie.getMessage(), ie);
                    }
                }
            }
        }
        try {
            service.stop(force, appExitCode);
        }
        catch (Exception e) {
            this.myStartingState.updateServiceState(service.getDescriptor().getId(), Status.ERROR, this.constructStatusMessage(e));
            throw e;
        }
        this.myStartingState.updateServiceState(service.getDescriptor().getId(), Status.SHUT_DOWN);
    }

    public void stop(boolean force, AppExitCode suggestedExitCode) {
        try {
            this.myStartingState.beginShutdown();
            this.stopAllServices(force, suggestedExitCode);
        }
        finally {
            this.myStartingState.finishShutdown();
        }
    }

    private void stopAllServices(boolean force, AppExitCode suggestedExitCode) {
        ArrayList<String> errorServices = new ArrayList<String>();
        ArrayList<ServiceBase> reversedServices = new ArrayList<ServiceBase>(this.myServicesHolder.getSortedServices());
        Collections.reverse(reversedServices);
        for (Service service : reversedServices) {
            String presentableName = service.getDescriptor().getPresentableName();
            BundleConsoleLogger.get().info(String.format("Stopping %s", presentableName));
            try {
                this.stopService(service, force, suggestedExitCode);
            }
            catch (Throwable e) {
                BundleConsoleLogger.get().warn(String.format("Error stopping %s: %s", presentableName, e.getMessage()));
                errorServices.add(presentableName);
            }
        }
        if (!errorServices.isEmpty()) {
            throw new StatusException("Some services could not be stopped: " + ConfiguratorUtils.join(errorServices, (String)", "));
        }
    }

    @NotNull
    private Service getMainBundleService() {
        for (Service service : this.myServicesHolder.getSortedServices()) {
            if (!this.myServicesConfiguration.getBundleState().isDefaultServiceContainer(service.getDescriptor().getId())) continue;
            return service;
        }
        throw new IllegalStateException("Neither Default Servlet Container nor Configuration Wizard is found among Bundle services [" + Services.toString(this.getServiceDescriptorsMap().keySet()) + "]");
    }

    @NotNull
    private static String toString(@NotNull Collection<String> collection) {
        String result = "";
        for (String element : collection) {
            result = result + element;
            result = result + ", ";
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    @NotNull
    StatusDescriptor getBundleStatus() {
        StatusDescriptor bundleStatus;
        try {
            if (this.myStartingState.isStarting()) {
                ServiceBase afterStartService = this.myServicesHolder.getService(this.myServiceForRedirectionAfterStart.getId());
                if (afterStartService == null) {
                    throw new IllegalStateException(String.format("Service %s is unexpectedly not managed by Bundle", this.myServiceForRedirectionAfterStart.getId()));
                }
                bundleStatus = this.convert(this.myServiceStatusResolver.getServiceStatus(afterStartService));
            } else {
                Service mainBundleService = this.getMainBundleService();
                bundleStatus = mainBundleService.status();
            }
        }
        catch (Exception e) {
            this.LOG.debug(e.getMessage(), (Throwable)e);
            String bundlePresentationName = this.myServicesConfiguration.getBundleState().getBuildProperties().getBundlePresentationName();
            bundleStatus = new StatusDescriptor(Status.ERROR, "Exception while getting status of " + bundlePresentationName + ": " + e.getMessage());
        }
        return bundleStatus;
    }

    public void configure() {
        Properties serviceConfiguration;
        ServiceDescriptor descriptor;
        this.myServicesConfiguration.getBundleProperties().resetInternalPortsProperties();
        HashMap<String, Properties> serviceConfigsMap = new HashMap<String, Properties>();
        List<ServiceBase> sortedServices = this.myServicesHolder.getSortedServices();
        for (Service service : sortedServices) {
            descriptor = service.getDescriptor();
            serviceConfiguration = this.myServicesConfiguration.getServiceConfiguration(descriptor);
            serviceConfigsMap.put(descriptor.getId(), serviceConfiguration);
        }
        this.logServiceVersions(sortedServices);
        this.checkServicesFolders(serviceConfigsMap);
        for (int i = 0; i < sortedServices.size(); ++i) {
            Service service = sortedServices.get(i);
            descriptor = service.getDescriptor();
            serviceConfiguration = (Properties)serviceConfigsMap.get(descriptor.getId());
            BundleConsoleLogger.get().info(String.format("Configuring %s", descriptor.getPresentableName()));
            try {
                service.configure(serviceConfiguration);
                continue;
            }
            catch (StatusException | ExecuteServiceCommandException e) {
                this.handleConfigureServiceException(sortedServices, i, serviceConfiguration, (RuntimeException)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleConfigureServiceException(List<ServiceBase> services, int i, Properties serviceConfiguration, RuntimeException e) {
        Service service = services.get(i);
        StatusDescriptor statusDescriptor = this.convert(this.myServiceStatusResolver.getServiceStatus(service, false));
        if (statusDescriptor.getStatus() != Status.RUNNING) throw e;
        if (this.myServicesConfiguration.getBundleState().isStartingMode() || this.myServicesConfiguration.getBundleState().getProperties().shouldShutdownServicesOnConfigure()) {
            ArrayList<ServiceBase> notConfiguredServices = new ArrayList<ServiceBase>(services.subList(i, services.size()));
            Collections.reverse(notConfiguredServices);
            for (ServiceBase notConfiguredService : notConfiguredServices) {
                this.stopService(notConfiguredService, true, AppExitCode.EXIT);
            }
        } else {
            ArrayList<ServiceDescriptor> runningServices = new ArrayList<ServiceDescriptor>();
            runningServices.add(service.getDescriptor());
            ArrayList<ServiceBase> notConfiguredServices = new ArrayList<ServiceBase>(services.subList(i + 1, services.size()));
            for (ServiceBase notConfiguredService : notConfiguredServices) {
                StatusDescriptor notConfiguredServiceStatusDescriptor = this.convert(this.myServiceStatusResolver.getServiceStatus(notConfiguredService, false));
                if (notConfiguredServiceStatusDescriptor.getStatus() != Status.RUNNING) continue;
                runningServices.add(notConfiguredService.getDescriptor());
            }
            throw new ServicesAlreadyStartedException(runningServices, (Throwable)e);
        }
        service.configure(serviceConfiguration);
    }

    private void checkServicesFolders(Map<String, Properties> serviceConfigsMap) {
        ArrayList<String> errorList = new ArrayList<String>();
        for (Map.Entry<String, Properties> entries : serviceConfigsMap.entrySet()) {
            String serviceId = entries.getKey();
            Properties serviceProperties = entries.getValue();
            if (Boolean.valueOf(serviceProperties.getProperty("is-internal-service")).booleanValue()) continue;
            errorList.addAll(this.checkServiceFolders(serviceProperties, serviceId));
        }
        if (!errorList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String errorMessage : errorList) {
                sb.append(errorMessage).append(System.lineSeparator());
                this.LOG.error(errorMessage);
            }
            throw new StatusException("The following issues related to configured service folders were identified: " + sb);
        }
    }

    private List<String> checkServiceFolders(Properties properties, String serviceId) {
        ArrayList<String> errors = new ArrayList<String>();
        for (String folderPropName : CHECKED_FOLDERS_PROPERTY_NAMES) {
            String errorMessage;
            String folder = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)properties, serviceId, folderPropName);
            if (folder == null) continue;
            Path folderPath = Paths.get(folder, new String[0]);
            BundleProperties.FolderType folderType = BundleProperties.FolderType.resolve(folderPropName);
            if (folderType != null && folderPath.startsWith(this.myServicesConfiguration.getBundleState().getProperties().getAbsoluteBundleDirectory(folderType)) || (errorMessage = SystemUtil.checkFolderIsWritable((File)folderPath.toFile())) == null) continue;
            errors.add(errorMessage);
        }
        return errors;
    }

    public List<ServiceInfo> getAllServices() {
        ArrayList<ServiceInfo> serviceInfoList = new ArrayList<ServiceInfo>();
        for (ServiceBase service : this.myServicesHolder.getSortedServices()) {
            ServiceDescriptor descriptor = service.getDescriptor();
            ServiceInfo serviceInfo = new ServiceInfo();
            serviceInfo.setName(descriptor.getPresentableName());
            serviceInfo.setId(descriptor.getId());
            serviceInfo.setHomeUrl(service.getDescriptor().isWebApp() ? service.getProperty("base-url") : null);
            serviceInfo.setDefault(this.myServicesConfiguration.getBundleState().getBuildProperties().isDefaultService(descriptor.getId()));
            serviceInfo.setInternal(service.getDescriptor().isInternal());
            serviceInfoList.add(serviceInfo);
        }
        return serviceInfoList;
    }

    @NotNull
    public Map<String, ServiceStatus> getStatuses(Collection<String> serviceIds) {
        HashMap<String, ServiceStatus> statusMap = new HashMap<String, ServiceStatus>();
        for (Service service : this.myServicesHolder.getSortedServices()) {
            if (serviceIds != null && !serviceIds.contains(service.getDescriptor().getId())) continue;
            ServiceStatus status = this.myServiceStatusResolver.getServiceStatus(service);
            statusMap.put(service.getDescriptor().getId(), status);
        }
        return statusMap;
    }

    @NotNull
    public ServiceStatus getServiceStatus(String id) {
        Service service = this.findService(id);
        return this.myServiceStatusResolver.getServiceStatus(service);
    }

    public boolean isBundleStarting() {
        return this.myStartingState.isStarting();
    }

    public boolean isBundleShutdownInProgress() {
        return this.myStartingState.isShutdownInProgress();
    }

    public ProductState getProductState() {
        BundleState bundleState = this.myServicesConfiguration.getBundleState();
        ServiceBase wizardService = this.myServicesHolder.getService("configurationWizard");
        return new ProductState(this.isBundleStarting(), wizardService != null, bundleState.getBuildProperties().getBundleProductName(), bundleState.getBuildProperties().getBundlePresentationName(), bundleState.getProperties().getAbsoluteBundleDirectory(BundleProperties.FolderType.LOGS).toFile(), wizardService != null && !UrlUtil.trimSlashes((String)wizardService.getDescriptor().getContext()).isEmpty() ? "" : UrlUtil.ensureEndsWithSlash((String)bundleState.getProperties().getServiceUrl(this.myServiceForRedirectionAfterStart)), bundleState.getRunId(), bundleState.getProperties().getContext());
    }

    @NotNull
    private StatusDescriptor convert(@NotNull ServiceStatus serviceStatus) {
        Status status = "PREPARING_TO_START".equals(serviceStatus.getStatus()) ? Status.STARTING : Status.parse((String)serviceStatus.getStatus());
        return new StatusDescriptor(status, serviceStatus.getDescription());
    }

    @NotNull
    private ServiceDescriptor getAfterStartService() {
        return Services.getAfterStartService(this.myServicesConfiguration.getBundleState().getBuildProperties(), this.getServiceDescriptorsMap());
    }

    @NotNull
    public static ServiceDescriptor getAfterStartService(Properties properties, Map<String, ServiceDescriptor> serviceMap) {
        return Services.getAfterStartService(PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)properties, "default.service"), serviceMap);
    }

    @NotNull
    private static ServiceDescriptor getAfterStartService(BundleBuildProperties bundleBuildProperties, Map<String, ServiceDescriptor> serviceMap) {
        return Services.getAfterStartService(bundleBuildProperties.getDefaultService(), serviceMap);
    }

    @NotNull
    private static ServiceDescriptor getAfterStartService(String defaultServiceId, Map<String, ServiceDescriptor> serviceMap) {
        if (serviceMap.isEmpty()) {
            throw new IllegalStateException("At least one services must be passed as parameter");
        }
        if (serviceMap.containsKey("configurationWizard")) {
            return serviceMap.get("configurationWizard");
        }
        if (serviceMap.containsKey("startingPage")) {
            return serviceMap.get("startingPage");
        }
        if (defaultServiceId != null && serviceMap.containsKey(defaultServiceId)) {
            return serviceMap.get(defaultServiceId);
        }
        if (serviceMap.containsKey("adminService")) {
            return serviceMap.get("adminService");
        }
        if (serviceMap.containsKey("hub")) {
            return serviceMap.get("hub");
        }
        for (ServiceDescriptor descriptor : serviceMap.values()) {
            if (descriptor.isInternal()) continue;
            return descriptor;
        }
        return serviceMap.values().iterator().next();
    }

    private static List<Locale> getSupportedLocales(Map<String, ServiceDescriptor> serviceMap) {
        List<Locale> locales = null;
        for (ServiceDescriptor serviceDescriptor : serviceMap.values()) {
            Collection<Locale> supportedLocales = serviceDescriptor.getSupportedLocales();
            if (supportedLocales.isEmpty() && !serviceDescriptor.isInternal()) {
                supportedLocales.addAll(DEFAULT_SUPPORTED_LOCALES);
            }
            if (supportedLocales.isEmpty()) continue;
            if (locales == null) {
                locales = new ArrayList<Locale>(supportedLocales);
                continue;
            }
            locales.retainAll(supportedLocales);
        }
        if (locales != null && locales.isEmpty()) {
            throw new IllegalStateException("There is no locale exists that is supported by all services in Bundle");
        }
        return locales != null ? locales : DEFAULT_SUPPORTED_LOCALES;
    }

    private void onServiceStarted(@NotNull ServiceDescriptor descriptor, Throwable t) {
        ServiceStartedEvent event = new ServiceStartedEvent(this.myServicesConfiguration.getBundleState(), descriptor);
        for (BundleListener<ServiceStartedEvent> listener : this.myServiceStartedListeners) {
            try {
                if (t == null) {
                    listener.onSuccess(event);
                    continue;
                }
                listener.onFailure(event, t);
            }
            catch (Exception e) {
                this.LOG.debug(String.format("Listener [%s] failed to process 'service started' event: %s", listener.getClass().getName(), e.getMessage()), (Throwable)e);
            }
        }
    }

    private String constructStatusMessage(Exception e) {
        try {
            String statusMessage = e instanceof ExecuteServiceCommandException && ((ExecuteServiceCommandException)((Object)e)).getCommandExecutionResult().myCommandError != null ? ((ExecuteServiceCommandException)((Object)e)).getCommandExecutionResult().myCommandError : ExceptionUtils.getStackTrace((Throwable)e);
            return Services.stripStatusMessage(statusMessage);
        }
        catch (Exception e1) {
            this.LOG.debug("Failed to construct service status message", (Throwable)e1);
            return e.getMessage();
        }
    }

    private static String stripStatusMessage(String statusMessage) {
        String strippedStatusMessage = statusMessage;
        if (statusMessage != null && statusMessage.length() > STATUS_MESSAGE_MAX_LENGTH_IN_CHARS) {
            String endOfStatusMessage;
            int firstLineEnding;
            String lineSeparator = System.getProperty("line.separator");
            String beginningOfStatusMessage = statusMessage.substring(0, STATUS_MESSAGE_MAX_LENGTH_IN_CHARS / 2);
            int lastLineEnding = beginningOfStatusMessage.lastIndexOf(lineSeparator);
            if (lastLineEnding + lineSeparator.length() <= beginningOfStatusMessage.length()) {
                beginningOfStatusMessage = beginningOfStatusMessage.substring(0, lastLineEnding + lineSeparator.length());
            }
            if ((firstLineEnding = (endOfStatusMessage = statusMessage.substring(statusMessage.length() - STATUS_MESSAGE_MAX_LENGTH_IN_CHARS / 2, statusMessage.length())).indexOf(lineSeparator)) > 0 && firstLineEnding + lineSeparator.length() < endOfStatusMessage.length()) {
                endOfStatusMessage = endOfStatusMessage.substring(firstLineEnding + lineSeparator.length(), endOfStatusMessage.length());
            }
            strippedStatusMessage = beginningOfStatusMessage + lineSeparator + String.format("############## %s lines in between were skipped from the output, all messages including skipped ones might be found in log files ##############", statusMessage.length() - STATUS_MESSAGE_MAX_LENGTH_IN_CHARS) + lineSeparator + endOfStatusMessage;
        }
        return strippedStatusMessage;
    }

    private void logServiceVersions(List<ServiceBase> sortedServices) {
        StringBuilder sb = new StringBuilder();
        for (Service service : sortedServices) {
            ServiceDescriptor descriptor = service.getDescriptor();
            if (descriptor.isInternal()) continue;
            sb.append(String.format("[%s->%s] %s", descriptor.getId(), descriptor.getVersion(), System.lineSeparator()));
        }
        if (sb.length() > 0) {
            sb.append(String.format("[bundle-platform->%s]", this.myServicesConfiguration.getBundleState().getBuildProperties().getBundleVersion()));
            this.LOG.info(String.format("Versions of services bundled into %s: %s%s", this.myServicesConfiguration.getBundleState().getBuildProperties().getBundlePresentationName(), System.lineSeparator(), sb.toString()));
        }
    }

    private static class CachedItem<T> {
        final long creationTimeMillis;
        final T item;

        CachedItem(T item) {
            this(System.currentTimeMillis(), item);
        }

        CachedItem(long creationTime, T item) {
            this.creationTimeMillis = creationTime;
            this.item = item;
        }
    }

    private class ServiceStatusResolver {
        private static final int STATUS_VALIDITY_TIME_IN_MILLIS = 5000;
        private static final int STATUS_REQUEST_TIMEOUT_IN_MILLIS = 30000;
        private final ConcurrentHashMap<String, CachedItem<StatusDescriptor>> statuses = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, CachedItem<Future<StatusDescriptor>>> statusesFutures = new ConcurrentHashMap();
        private final Map<String, Object> serviceMonitors;

        ServiceStatusResolver(ServicesHolder servicesHolder) {
            ConcurrentHashMap<String, Object> tmpServiceMonitors = new ConcurrentHashMap<String, Object>();
            for (String serviceId : servicesHolder.getSortedServicesIds()) {
                tmpServiceMonitors.put(serviceId, new Object());
            }
            this.serviceMonitors = Collections.unmodifiableMap(tmpServiceMonitors);
        }

        @NotNull
        private StatusDescriptor getServiceStatusDirectlyFromService(@NotNull Service service) {
            StatusDescriptor statusDescriptor;
            try {
                statusDescriptor = service.status();
            }
            catch (Exception e) {
                statusDescriptor = new StatusDescriptor(Status.ERROR, "Exception occurred while getting status of service [" + service.getDescriptor().getId() + "]: " + e.getMessage());
            }
            return statusDescriptor;
        }

        @NotNull
        private ServiceStatus getServiceStatus(@NotNull Service service) {
            return this.getServiceStatus(service, true);
        }

        @NotNull
        private ServiceStatus getServiceStatus(@NotNull Service service, boolean useCache) {
            ServiceStatus serviceStatus = !useCache ? this.convert(this.getServiceStatusDirectlyFromService(service)) : this.getCachedStatus(service);
            return serviceStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServiceStatus getCachedStatus(final @NotNull Service service) {
            StatusDescriptor result;
            String serviceId = service.getDescriptor().getId();
            ServiceStatus serviceStatusFromStartingState = Services.this.myStartingState.getServiceStatus(serviceId);
            if (serviceStatusFromStartingState != null) {
                return serviceStatusFromStartingState;
            }
            CachedItem<StatusDescriptor> descriptor = this.statuses.get(serviceId);
            if (descriptor == null || System.currentTimeMillis() - descriptor.creationTimeMillis >= 5000L) {
                Object serviceMonitor;
                Object object = serviceMonitor = this.serviceMonitors.get(serviceId);
                synchronized (object) {
                    descriptor = this.statuses.get(serviceId);
                    if (descriptor == null) {
                        descriptor = new CachedItem<StatusDescriptor>(System.currentTimeMillis() - 5000L, new StatusDescriptor(Status.RUNNING, "default service status"));
                        this.statuses.put(serviceId, descriptor);
                    }
                    if (System.currentTimeMillis() - descriptor.creationTimeMillis >= 5000L) {
                        CachedItem<Future<StatusDescriptor>> statusDescriptorFuture = this.statusesFutures.get(serviceId);
                        if (statusDescriptorFuture == null) {
                            statusDescriptorFuture = new CachedItem<Future<StatusDescriptor>>(Executors.newSingleThreadExecutor().submit(new Callable<StatusDescriptor>(){

                                @Override
                                public StatusDescriptor call() throws Exception {
                                    return ServiceStatusResolver.this.getServiceStatusDirectlyFromService(service);
                                }
                            }));
                            this.statusesFutures.put(serviceId, statusDescriptorFuture);
                        }
                        StatusDescriptor statusDescriptor = null;
                        if (((Future)statusDescriptorFuture.item).isDone()) {
                            try {
                                statusDescriptor = (StatusDescriptor)((Future)statusDescriptorFuture.item).get();
                                this.statusesFutures.remove(serviceId);
                            }
                            catch (InterruptedException | ExecutionException e) {
                                this.cancelStatusRequest(serviceId, (Future)statusDescriptorFuture.item);
                                throw new RuntimeException(e);
                            }
                        } else if (System.currentTimeMillis() - statusDescriptorFuture.creationTimeMillis >= 30000L) {
                            this.cancelStatusRequest(serviceId, (Future)statusDescriptorFuture.item);
                            statusDescriptor = new StatusDescriptor(Status.ERROR, String.format("Failed to get status of service %s for %s milliseconds", serviceId, 30000));
                        }
                        if (statusDescriptor != null) {
                            this.statuses.put(serviceId, new CachedItem<StatusDescriptor>(statusDescriptor));
                        } else {
                            statusDescriptor = (StatusDescriptor)descriptor.item;
                        }
                        result = statusDescriptor;
                    } else {
                        result = (StatusDescriptor)descriptor.item;
                    }
                }
            } else {
                result = (StatusDescriptor)descriptor.item;
            }
            return this.convert(result);
        }

        private void cancelStatusRequest(String serviceId, Future<StatusDescriptor> statusDescriptorFuture) {
            try {
                statusDescriptorFuture.cancel(true);
            }
            catch (Exception e1) {
                Services.this.LOG.debug(String.format("Failed to cancel status request to service %s", serviceId), (Throwable)e1);
            }
            this.statusesFutures.remove(serviceId);
        }

        @NotNull
        private ServiceStatus convert(@NotNull StatusDescriptor statusDescriptor) {
            ServiceStatus result = new ServiceStatus();
            result.setStatus(statusDescriptor.getStatus().name());
            result.setDescription(statusDescriptor.getDescription());
            return result;
        }
    }

    private static class StartingState {
        static final String PREPARING_TO_START_STATUS = "PREPARING_TO_START";
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        private final Logger LOG = LoggerFactory.getLogger(this.getClass());
        private volatile boolean isStarting;
        private volatile boolean isShutdownInProcess;
        private Map<String, StatusDescriptor> serviceStatuses = new ConcurrentHashMap<String, StatusDescriptor>();

        private StartingState() {
        }

        void beginShutdown() {
            try {
                this.rwLock.writeLock().lock();
                if (this.isShutdownInProcess) {
                    throw new IllegalStateException("Services have already begun shutting down. ");
                }
                this.isShutdownInProcess = true;
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }

        void finishShutdown() {
            try {
                this.rwLock.writeLock().lock();
                if (!this.isShutdownInProcess) {
                    throw new IllegalStateException("Shutting down process has not been started - nothing to finish yet");
                }
                this.isShutdownInProcess = false;
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }

        void beginStarting() {
            try {
                this.rwLock.writeLock().lock();
                if (this.isStarting) {
                    throw new IllegalStateException("Services have already begun starting. The previous starting process should be finished prior to services might be starting on more time");
                }
                this.isStarting = true;
                this.serviceStatuses.clear();
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }

        void finishStarting() {
            try {
                this.rwLock.writeLock().lock();
                if (!this.isStarting) {
                    throw new IllegalStateException("Service has not been starting yet - nothing to finish");
                }
                this.isStarting = false;
                this.serviceStatuses.clear();
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }

        void updateServiceState(@NotNull String service, @NotNull Status status) {
            this.updateServiceState(service, status, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateServiceState(@NotNull String service, @NotNull Status status, String statusMessage) {
            this.LOG.debug(String.format("Set status [%s] for service [%s]", status, service));
            try {
                this.rwLock.writeLock().lock();
                if (status == Status.STARTING && this.isShutdownInProcess) {
                    String errorMessage = String.format("Service %s won't be started, because shut down process has been initiated", service);
                    this.LOG.debug(errorMessage);
                    throw new StatusException(errorMessage);
                }
                StatusDescriptor currentStatus = this.serviceStatuses.get(service);
                if (currentStatus != null && Status.STARTING == currentStatus.getStatus()) {
                    if (Status.SHUTTING_DOWN == status) {
                        String errorMessage = String.format("Service %s is starting, shut down should wait until starting finished", service);
                        this.LOG.debug(errorMessage);
                        throw new StatusException(errorMessage);
                    }
                    if (Status.RUNNING == status && this.isShutdownInProcess) {
                        this.serviceStatuses.put(service, new StatusDescriptor(status, statusMessage));
                        String errorMessage = String.format("Service %s was started successfully, but shut down process has been initiated", service);
                        this.LOG.debug(errorMessage);
                        throw new StatusException(errorMessage);
                    }
                }
                if (this.isStarting && Status.SHUTTING_DOWN == status && currentStatus == null) {
                } else {
                    String resultStatusMessage = statusMessage;
                    if (resultStatusMessage == null && this.isStarting && (Status.SHUTTING_DOWN == status || Status.ERROR == status || Status.SHUT_DOWN == status) && currentStatus != null) {
                        resultStatusMessage = currentStatus.getDescription();
                    }
                    this.serviceStatuses.put(service, new StatusDescriptor(status, resultStatusMessage));
                }
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ServiceStatus getServiceStatus(String serviceId) {
            ServiceStatus serviceStatus = null;
            try {
                this.rwLock.readLock().lock();
                if (this.isStarting) {
                    StatusDescriptor statusFromMap = this.serviceStatuses.get(serviceId);
                    String status = statusFromMap != null ? statusFromMap.getStatus().name() : PREPARING_TO_START_STATUS;
                    serviceStatus = new ServiceStatus();
                    serviceStatus.setStatus(status);
                    if (statusFromMap != null) {
                        serviceStatus.setDescription(statusFromMap.getDescription());
                    }
                }
            }
            finally {
                this.rwLock.readLock().unlock();
            }
            return serviceStatus;
        }

        boolean isStarting() {
            try {
                this.rwLock.readLock().lock();
                boolean bl = this.isStarting;
                return bl;
            }
            finally {
                this.rwLock.readLock().unlock();
            }
        }

        boolean isShutdownInProgress() {
            try {
                this.rwLock.readLock().lock();
                boolean bl = this.isShutdownInProcess;
                return bl;
            }
            finally {
                this.rwLock.readLock().unlock();
            }
        }
    }
}

