/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.api.internal.backend.impl;

import com.jetbrains.bundle.api.clientcert.model.ClientCertAuthSettings;
import com.jetbrains.bundle.api.exceptions.BundleBackendException;
import com.jetbrains.bundle.api.internal.auth.AuthResult;
import com.jetbrains.bundle.api.internal.backend.BundleFacade;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

public class BundleFacadeDelegate
implements BundleFacade {
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static volatile BundleFacade myBundleFacade;

    @NotNull
    public AuthResult authenticate(@NotNull String bundleBackendToken) {
        BundleFacade bundleFacade = BundleFacadeDelegate.getBundleFacade();
        return bundleFacade.authenticate(bundleBackendToken);
    }

    public void updateProperty(@NotNull String name, @NotNull String value) throws BundleBackendException {
        BundleFacade bundleFacade = BundleFacadeDelegate.getBundleFacade();
        bundleFacade.updateProperty(name, value);
    }

    public void updateProperty(@NotNull String name, @NotNull String value, boolean skipValidation) throws BundleBackendException {
        BundleFacade bundleFacade = BundleFacadeDelegate.getBundleFacade();
        bundleFacade.updateProperty(name, value, skipValidation);
    }

    public void validateProperty(@NotNull String name, @NotNull String value) throws BundleBackendException {
        BundleFacade bundleFacade = BundleFacadeDelegate.getBundleFacade();
        bundleFacade.validateProperty(name, value);
    }

    public String getProperty(@NotNull String name) throws BundleBackendException {
        BundleFacade bundleFacade = BundleFacadeDelegate.getBundleFacade();
        return bundleFacade.getProperty(name);
    }

    public void changeClientCertificateAuthSettings(boolean isEnabled, List<String> certPemEncoded) {
        BundleFacade bundleFacade = BundleFacadeDelegate.getBundleFacade();
        bundleFacade.changeClientCertificateAuthSettings(isEnabled, certPemEncoded);
    }

    public ClientCertAuthSettings getClientCertificateAuthSettings() {
        BundleFacade bundleFacade = BundleFacadeDelegate.getBundleFacade();
        return bundleFacade.getClientCertificateAuthSettings();
    }

    public static void setBundleFacade(BundleFacade bundleFacade) {
        try {
            rwLock.writeLock().lock();
            myBundleFacade = bundleFacade;
        }
        finally {
            rwLock.writeLock().unlock();
        }
    }

    @NotNull
    public static BundleFacade getBundleFacade() {
        try {
            rwLock.readLock().lock();
            if (myBundleFacade == null) {
                throw new IllegalStateException("BundleFacade is not initialized");
            }
            BundleFacade bundleFacade = myBundleFacade;
            return bundleFacade;
        }
        finally {
            rwLock.readLock().unlock();
        }
    }
}

