/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.api.internal.backend.impl;

import com.jetbrains.bundle.BundleState;
import com.jetbrains.bundle.api.clientcert.model.ClientCertAuthSettings;
import com.jetbrains.bundle.api.exceptions.BundleBackendException;
import com.jetbrains.bundle.api.internal.auth.AuthResult;
import com.jetbrains.bundle.api.internal.backend.BundleFacade;
import com.jetbrains.bundle.api.internal.backend.impl.ErrorInfoCreator;
import com.jetbrains.bundle.api.model.ErrorInfo;
import com.jetbrains.bundle.client.error.BundleBackendErrorCode;
import com.jetbrains.bundle.client.error.ErrorMessageCreator;
import com.jetbrains.bundle.proxy.jetty.BundleProxy;
import com.jetbrains.bundle.services.impl.HubConfiguratorService;
import com.jetbrains.bundle.services.impl.InProcessJettyService;
import com.jetbrains.service.util.BundleProperty;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleFacadeImpl
implements BundleFacade {
    private final String myBackendToken;
    private final BundleState myBundleState;
    private final File myBundleBackendStorage;
    private Logger LOG = LoggerFactory.getLogger(this.getClass());

    public BundleFacadeImpl(@NotNull String token, @NotNull BundleState bundleState, @NotNull File bundleBackendStorage) {
        this.myBackendToken = token;
        this.myBundleState = bundleState;
        this.myBundleBackendStorage = bundleBackendStorage;
    }

    @NotNull
    public AuthResult authenticate(@NotNull String bundleBackendToken) {
        return new AuthResult(this.myBackendToken.equals(bundleBackendToken) ? AuthResult.Code.SUCCESS : AuthResult.Code.FAILED, null, this.myBundleBackendStorage);
    }

    public void updateProperty(@NotNull String name, @NotNull String value) throws BundleBackendException {
        this.updateProperty(name, value, false);
    }

    public void updateProperty(@NotNull String name, @NotNull String value, boolean skipValidation) throws BundleBackendException {
        Map<BundleProperty, String> updatedProperties = this.myBundleState.getProperties().updatePropertyInRuntime(name, value, skipValidation);
        if (updatedProperties.containsKey(BundleProperty.BASE_URL) && this.myBundleState.getServices().getServiceDescriptorsMap().containsKey("bundle-hub-configurator")) {
            HubConfiguratorService hubConfiguratorService = new HubConfiguratorService(this.myBundleState.getServices().getServiceDescriptorsMap().get("bundle-hub-configurator"), this.myBundleState.getEnvironment(), this.myBundleState.getContextHolder());
            Properties renewedServiceConfiguration = this.myBundleState.getServices().calculateServiceConfiguration(this.myBundleState.getServices().getServiceDescriptorsMap().get("bundle-hub-configurator"));
            hubConfiguratorService.configure(renewedServiceConfiguration);
            try {
                hubConfiguratorService.start();
            }
            catch (Exception e) {
                this.LOG.warn(String.format("Failed to update Hub Services after bundle property %s was updated", name), (Throwable)e);
            }
        }
    }

    public void validateProperty(@NotNull String name, @NotNull String value) throws BundleBackendException {
        this.myBundleState.getProperties().tryUpdatePropertyInRuntime(name, value, false);
    }

    public String getProperty(@NotNull String name) throws BundleBackendException {
        BundleProperty bundleProperty = BundleProperty.getSimplePropertyByName((String)name);
        if (bundleProperty == null) {
            throw new BundleBackendException(name, (ErrorInfo)BundleBackendErrorCode.UNKNOWN_PROPERTY.toError(Collections.singletonMap("property", name), (ErrorMessageCreator)ErrorInfoCreator.get()));
        }
        return this.myBundleState.getProperties().getPropertyValueInExternalFormat(bundleProperty.getName());
    }

    public void changeClientCertificateAuthSettings(boolean isEnabled, List<String> certPemEncoded) {
        BundleProxy bundleProxy = this.getBundleProxyService();
        bundleProxy.changeClientCertificateAuthSettings(isEnabled, certPemEncoded);
    }

    public ClientCertAuthSettings getClientCertificateAuthSettings() {
        BundleProxy bundleProxy = this.getBundleProxyService();
        return bundleProxy.getClientCertificateAuthSettings();
    }

    @NotNull
    private BundleProxy getBundleProxyService() {
        return (BundleProxy)((InProcessJettyService)this.myBundleState.getServices().findService("bundleProcess")).getWrappedService();
    }
}

