/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.api.internal.services.impl;

import com.jetbrains.bundle.api.internal.services.ServicesInformationProvider;
import com.jetbrains.bundle.api.internal.services.model.ProductState;
import com.jetbrains.bundle.api.internal.services.model.ServiceInfo;
import com.jetbrains.bundle.api.internal.services.model.ServiceStatus;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

public class ServicesInformationProviderImpl
implements ServicesInformationProvider {
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static volatile ServicesInformationProvider myProvider;

    public List<ServiceInfo> getAllServices() {
        ServicesInformationProvider currentProvider = ServicesInformationProviderImpl.getMyProvider();
        return currentProvider.getAllServices();
    }

    @NotNull
    public ServiceStatus getServiceStatus(String id) {
        ServicesInformationProvider currentProvider = ServicesInformationProviderImpl.getMyProvider();
        return currentProvider.getServiceStatus(id);
    }

    public Map<String, ServiceStatus> getStatuses(Collection<String> serviceIds) {
        ServicesInformationProvider currentProvider = ServicesInformationProviderImpl.getMyProvider();
        return currentProvider.getStatuses(serviceIds);
    }

    public boolean isBundleStarting() {
        ServicesInformationProvider currentProvider = ServicesInformationProviderImpl.getMyProvider();
        return currentProvider.isBundleStarting();
    }

    public ProductState getProductState() {
        ServicesInformationProvider currentProvider = ServicesInformationProviderImpl.getMyProvider();
        return currentProvider.getProductState();
    }

    public static void setProvider(ServicesInformationProvider provider) {
        try {
            rwLock.writeLock().lock();
            myProvider = provider;
        }
        finally {
            rwLock.writeLock().unlock();
        }
    }

    private static ServicesInformationProvider getMyProvider() {
        try {
            rwLock.readLock().lock();
            if (myProvider == null) {
                throw new IllegalStateException("StatusInformationProvider is not initialized");
            }
            ServicesInformationProvider servicesInformationProvider = myProvider;
            return servicesInformationProvider;
        }
        finally {
            rwLock.readLock().unlock();
        }
    }
}

