/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.launcher.config.impl;

import com.jetbrains.bundle.BundleProperties;
import com.jetbrains.bundle.BundleState;
import com.jetbrains.bundle.launcher.config.ConsistencyKeeper;
import com.jetbrains.launcher.contexts.ApplicationContext;
import com.jetbrains.service.util.cmd.CmdUtil;
import com.jetbrains.service.util.cmd.ExecutionContext;
import com.jetbrains.service.util.cmd.ExecutionResult;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConsistencyKeeperBase<T extends ApplicationContext>
implements ConsistencyKeeper {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static final int RECONFIGURE_LAUNCHER_TIMEOUT_IN_MILLIS = 60000;

    @Override
    public void addBundleLifeCycleListeners(BundleState bundleState) {
    }

    @Override
    public final void updateLauncherConfig(BundleState bundleState) {
        Properties outDatedLauncherProperties = this.getOutDatedLauncherProperties(bundleState);
        if (!outDatedLauncherProperties.isEmpty()) {
            this.processOutdatedConfig(outDatedLauncherProperties, bundleState);
        }
    }

    protected void processOutdatedConfig(@NotNull Properties outDatedLauncherProperties, @NotNull BundleState bundleState) {
        ExecutionResult result = this.executeLauncherReconfiguration(bundleState, outDatedLauncherProperties);
        this.handleLauncherReconfigurationResult(outDatedLauncherProperties, result, bundleState);
    }

    protected abstract void handleLauncherReconfigurationResult(@NotNull Properties var1, @NotNull ExecutionResult var2, @NotNull BundleState var3);

    @NotNull
    private ExecutionResult executeLauncherReconfiguration(BundleState bundleState, Properties outDatedLauncherProperties) {
        ArrayList<String> additionalProperties = new ArrayList<String>();
        additionalProperties.add("--launcher");
        if (bundleState.getContextHolder().isDebugEnabled()) {
            additionalProperties.add("--debug");
        }
        for (String propertyName : outDatedLauncherProperties.stringPropertyNames()) {
            additionalProperties.add("--" + propertyName + "=" + outDatedLauncherProperties.getProperty(propertyName));
        }
        return this.executeBundleCommandWithExitCode(Collections.singletonList("configure"), additionalProperties, null, bundleState);
    }

    private Properties getOutDatedLauncherProperties(BundleState bundleState) {
        Properties outDatedLauncherProperties = new Properties();
        Path bundleLogsDirectory = bundleState.getProperties().getAbsoluteBundleDirectory(BundleProperties.FolderType.LOGS);
        Path launcherLogsDirPath = bundleState.getContextHolder().getContext().getAppFiles().getAppLogsFolder().toPath();
        if (!launcherLogsDirPath.equals(bundleLogsDirectory) || bundleState.isRunAfterWizardCompletion()) {
            outDatedLauncherProperties.setProperty(BundleProperties.FolderType.LOGS.getBundleProperty().getName(), bundleLogsDirectory.toString());
        } else {
            this.LOG.debug(String.format("Logs directory either hasn't been changed or has already been reconfigured. It is located at [%s]", bundleLogsDirectory));
        }
        return outDatedLauncherProperties;
    }

    @NotNull
    private ExecutionResult executeBundleCommandWithExitCode(List<String> command, List<String> additionalArguments, ExecutionContext context, BundleState bundleState) {
        if (context == null) {
            ExecutionContext defaultExecutionCtx = new ExecutionContext();
            defaultExecutionCtx.put(ExecutionContext.Param.executionTimeoutInMillis, (Object)60000);
            defaultExecutionCtx.put(ExecutionContext.Param.logOutputToConsole, (Object)false);
            context = defaultExecutionCtx;
        }
        Path bundleHome = bundleState.getEnvironment().getBundleHome();
        String scriptName = CmdUtil.getScriptName((Path)bundleHome, (String)Paths.get("bin", new String[0]).resolve(bundleState.getContextHolder().getLauncherScriptName()).toString());
        return CmdUtil.executeCommandWithExitCode((String)scriptName, (Path)bundleHome, (String)"bundleProcess", command, additionalArguments, (ExecutionContext)context);
    }
}

