/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.proxy.jetty;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class AllowOriginOneTimeFilter
implements Filter {
    protected FilterConfig config;

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        Object newResponse = response;
        if (request instanceof HttpServletRequest) {
            newResponse = new AllowHeadersResponseWrapper((HttpServletResponse)response);
        }
        chain.doFilter(request, newResponse);
    }

    static class AllowHeadersResponseWrapper
    extends HttpServletResponseWrapper {
        private final HttpServletResponse myResponse;

        public AllowHeadersResponseWrapper(HttpServletResponse response) {
            super(response);
            this.myResponse = response;
        }

        public void addHeader(String name, String value) {
            HashSet set;
            Collection allowOrigins;
            if ("Access-Control-Allow-Origin".equals(name) && (allowOrigins = this.myResponse.getHeaders("Access-Control-Allow-Origin")) != null && (set = new HashSet(allowOrigins)).size() == 1 && ((String)set.iterator().next()).equals(value)) {
                return;
            }
            super.addHeader(name, value);
        }
    }
}

