/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.proxy.jetty;

import com.jetbrains.bundle.api.internal.services.ServicesInformationHelper;
import com.jetbrains.bundle.api.internal.services.ServicesInformationProvider;
import com.jetbrains.bundle.api.internal.services.model.ServiceInfo;
import com.jetbrains.bundle.proxy.jetty.WebSocketProxySocket;
import com.jetbrains.bundle.util.BundleJvmOption;
import com.jetbrains.bundle.util.BundleUtil;
import com.jetbrains.bundle.util.EncodingUtil;
import com.jetbrains.launcher.Status;
import com.jetbrains.service.util.UrlUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.AuthenticationProtocolHandler;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ProtocolHandlers;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServlet
extends ProxyServlet.Transparent {
    private static Logger LOG = LoggerFactory.getLogger(ProxyServlet.class);
    private final AtomicReference<WebSocketServletFactory> myFactory = new AtomicReference();
    private final String myServiceId;

    public ProxyServlet(String serviceId) {
        this.myServiceId = serviceId;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            URI wsProxyTo;
            WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
            policy.setMaxBinaryMessageSize(WebSocketProxySocket.MaxMessageSize);
            policy.setMaxTextMessageSize(WebSocketProxySocket.MaxMessageSize);
            String proxyTo = config.getInitParameter("proxyTo");
            if (proxyTo == null) {
                throw new UnavailableException("Init parameter 'proxyTo' is required.");
            }
            try {
                URI httpTo = URI.create(proxyTo);
                wsProxyTo = new URI(httpTo.getScheme().equals("https") ? "wss" : "ws", httpTo.getUserInfo(), httpTo.getHost(), httpTo.getPort(), httpTo.getPath(), httpTo.getQuery(), httpTo.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            WebSocketServletFactory factory = WebSocketServletFactory.Loader.load((ServletContext)config.getServletContext(), (WebSocketPolicy)policy);
            factory.setCreator(new WebSocketCreator(){

                public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
                    URI toWithQueryString;
                    String path = req.getRequestURI().getPath();
                    String queryString = req.getRequestURI().getQuery();
                    URI to = wsProxyTo.resolve(path);
                    try {
                        toWithQueryString = new URI(to.getScheme(), to.getUserInfo(), to.getHost(), to.getPort(), to.getPath(), queryString, null);
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                    return new WebSocketProxySocket(toWithQueryString);
                }
            });
            if (!Boolean.valueOf(BundleJvmOption.WS_COMPRESSION_ENABLED.get()).booleanValue()) {
                factory.getExtensionFactory().unregister("permessage-deflate");
            }
            factory.start();
            this.myFactory.set(factory);
        }
        catch (Throwable x) {
            LOG.error("Error initializing WebSocketServletFactory", x);
            throw new ServletException(x);
        }
    }

    public void destroy() {
        try {
            WebSocketServletFactory factory = this.myFactory.get();
            if (factory != null) {
                factory.stop();
            }
        }
        catch (Throwable t) {
            LOG.error("WebSocketServletFactory stop failed", t);
        }
        this.myFactory.set(null);
    }

    protected HttpClient newHttpClient() {
        HttpClient httpClient = new HttpClient(new SslContextFactory()){

            protected ProtocolHandler findProtocolHandler(Request request, Response response) {
                ProtocolHandlers protocolHandlers = this.getProtocolHandlers();
                ProtocolHandler handler = protocolHandlers.find(request, response);
                if (!(handler instanceof AuthenticationProtocolHandler)) {
                    return handler;
                }
                return null;
            }
        };
        httpClient.setFollowRedirects(false);
        return httpClient;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebSocketServletFactory factory = this.myFactory.get();
        if (factory != null && factory.isUpgradeRequest(request, response)) {
            if (factory.acceptWebSocket(request, response)) {
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.service(request, response);
    }

    protected void copyRequestHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
        Enumeration headerValues;
        super.copyRequestHeaders(clientRequest, proxyRequest);
        Set toRemoveHeaders = this.findConnectionHeaders(clientRequest);
        if (!(proxyRequest.getHeaders().containsKey(HttpHeader.HOST.name()) || toRemoveHeaders != null && toRemoveHeaders.contains(HttpHeader.HOST.name().toLowerCase(Locale.ENGLISH)) || (headerValues = clientRequest.getHeaders(HttpHeader.HOST.name())) == null)) {
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                if (headerValue == null) continue;
                proxyRequest.header(HttpHeader.HOST.name(), headerValue);
            }
        }
    }

    private void escapeQueryString(HttpServletRequest request) throws UnsupportedEncodingException {
        if (request instanceof org.eclipse.jetty.server.Request) {
            org.eclipse.jetty.server.Request jettyRequest = (org.eclipse.jetty.server.Request)request;
            String queryEncoding = jettyRequest.getQueryEncoding() != null ? jettyRequest.getQueryEncoding() : "UTF-8";
            String query = jettyRequest.getQueryString();
            String escapedQuery = query.replace("{", URLEncoder.encode("{", queryEncoding)).replace("}", URLEncoder.encode("}", queryEncoding)).replace("^", URLEncoder.encode("^", queryEncoding)).replace("|", URLEncoder.encode("|", queryEncoding)).replace("\"", URLEncoder.encode("\"", queryEncoding)).replace("`", URLEncoder.encode("`", queryEncoding));
            jettyRequest.setQueryString(escapedQuery);
        }
    }

    protected void onProxyResponseFailure(HttpServletRequest request, HttpServletResponse response, Response proxyResponse, Throwable failure) {
        String redirectionUrl;
        if (!response.isCommitted()) {
            LOG.info("Proxying {} failed: {}", new Object[]{request.getRequestURI(), proxyResponse.getReason(), failure});
        }
        if (!response.isCommitted() && !(failure instanceof TimeoutException) && (redirectionUrl = this.getRedirectionUrl(request)) != null) {
            try {
                String encodedRedirectUrl = response.encodeRedirectURL(redirectionUrl);
                response.sendRedirect(encodedRedirectUrl);
            }
            catch (IOException e) {
                LOG.warn(String.format("Can not redirect to service [%s]", redirectionUrl));
            }
        }
        super.onProxyResponseFailure(request, response, proxyResponse, failure);
    }

    private String getRedirectionUrl(HttpServletRequest request) {
        String redirectionUrl = null;
        try {
            List services;
            ServiceInfo startingPageServiceInfo;
            ServicesInformationProvider servicesInformationProvider = ServicesInformationHelper.getServicesInformationProvider();
            if (servicesInformationProvider.isBundleStarting() && (startingPageServiceInfo = this.findService(services = servicesInformationProvider.getAllServices(), "startingPage")) != null && Status.RUNNING == Status.parse((String)servicesInformationProvider.getServiceStatus("startingPage").getStatus())) {
                redirectionUrl = UrlUtil.addParameterToUrl((String)"serviceId", (String)this.myServiceId, (String)BundleUtil.resolveServiceUrlForClient((HttpServletRequest)request, (String)startingPageServiceInfo.getHomeUrl()));
                StringBuffer url = request.getRequestURL();
                if (request.getQueryString() != null) {
                    url.append("?").append(request.getQueryString());
                }
                String encodedUrl = EncodingUtil.encodeURIComponent(url.toString());
                redirectionUrl = UrlUtil.addParameterToUrl((String)"gotoUrl", (String)encodedUrl, (String)redirectionUrl);
            }
        }
        catch (Exception e) {
            LOG.debug(String.format("Can not redirect failed proxy request: %s", e.getMessage()), (Throwable)e);
        }
        return redirectionUrl;
    }

    private ServiceInfo findService(@NotNull List<ServiceInfo> services, @NotNull String serviceId) {
        ServiceInfo startingPageServiceInfo = null;
        for (ServiceInfo serviceInfo : services) {
            if (!serviceId.equals(serviceInfo.getId())) continue;
            startingPageServiceInfo = serviceInfo;
        }
        return startingPageServiceInfo;
    }
}

