/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.jetbrains.annotations.NotNull;

public class EncodingUtil {
    private static final String UTF_8_ENCODING = "UTF-8";

    public static String decodeURIComponent(@NotNull String s) {
        try {
            return URLDecoder.decode(s, UTF_8_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(String.format("Encoding [%s] is not supported by URLDecoder %s", UTF_8_ENCODING, e.getMessage()), e);
        }
    }

    @NotNull
    public static String encodeURIComponent(@NotNull String s) {
        try {
            return URLEncoder.encode(s, UTF_8_ENCODING).replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(String.format("Encoding [%s] is not supported by URLEncoder: %s", UTF_8_ENCODING, e.getMessage()), e);
        }
    }

    private EncodingUtil() {
    }
}

