/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.util.hub;

import com.jetbrains.bundle.hub_client.util.BundleHubClient;
import com.jetbrains.bundle.hub_client.util.HubServiceCheckResult;
import com.jetbrains.bundle.hub_client.util.HubUtil;
import com.jetbrains.bundle.util.hub.ServiceParameter;
import com.jetbrains.bundle.util.hub.ServiceParameters;
import com.jetbrains.bundle.util.hub.UpdaterHubServiceException;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.SystemUtil;
import com.jetbrains.service.util.UrlUtil;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import jersey.repackaged.com.google.common.collect.Sets;
import jetbrains.jetpass.client.BaseField;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.BaseAccountsClient;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.client.accounts.UserClient;
import jetbrains.jetpass.client.hub.HubClient;
import jetbrains.jetpass.client.resource.ErrorHelper;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubServiceUpdater {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final Properties newHubProperties;
    private final Properties oldHubProperties;
    private final BundleHubClient bundleHubClient;
    private boolean hubInIntegrationMode;
    private String rootGroupId;

    public HubServiceUpdater(Properties oldHubProperties, Properties newHubProperties, @NotNull BundleHubClient bundleHubClient) {
        this.oldHubProperties = oldHubProperties;
        this.newHubProperties = newHubProperties;
        this.bundleHubClient = bundleHubClient;
        this.hubInIntegrationMode = Boolean.valueOf(newHubProperties.getProperty("bundle.hub-used-by-external-services"));
    }

    @NotNull
    public Properties update() {
        Properties expectedHubProperties = new Properties(this.oldHubProperties);
        try {
            boolean reset = Boolean.valueOf(this.newHubProperties.getProperty("hub-reset"));
            this.updateHubInfo(expectedHubProperties, reset);
            List<String> hubServices = HubServiceUpdater.getHubServices(this.newHubProperties);
            Set<String> createdServices = this.ensureCreatedAndVerified(hubServices);
            this.updateServicesInfoInHub(expectedHubProperties, createdServices, hubServices);
            if (this.bundleHubClient.isInternalHub()) {
                this.updateGuestUserBanStatus(expectedHubProperties, reset);
            }
        }
        catch (Throwable t) {
            this.LOG.error("Cannot update services information in Hub", t);
            throw t;
        }
        finally {
            if (this.bundleHubClient.isInternalHub()) {
                this.bundleHubClient.deleteBundleHubService();
            }
        }
        return expectedHubProperties;
    }

    @NotNull
    private Set<String> ensureCreatedAndVerified(List<String> hubServices) {
        HashSet<String> createdServices = new HashSet<String>();
        for (String serviceIdInBundle : hubServices) {
            Boolean canBeUsed;
            String serviceBelongsTo = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.newHubProperties, serviceIdInBundle, "hub-service-belongs-to");
            if (serviceBelongsTo != null) {
                this.LOG.debug("Skip creating service {} since it belongs to another hub service {}", (Object)serviceIdInBundle, (Object)serviceBelongsTo);
                continue;
            }
            String serviceIdInHub = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.newHubProperties, serviceIdInBundle, "hub-service-id");
            String serviceSecret = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.newHubProperties, serviceIdInBundle, "hub-service-secret");
            if (serviceIdInHub == null || serviceSecret == null) {
                throw new IllegalStateException(String.format("Service id or secret not specified for service '%s'. Property %s or/and %s is not set", serviceIdInBundle, "hub-service-id", "hub-service-secret"));
            }
            BaseAccountsClient accountsClientForCheck = HubUtil.getAccountsClientByIdAndSecret((HubClient)this.bundleHubClient.getHubClient(), (String)serviceIdInHub, (String)serviceSecret);
            HubServiceCheckResult checkResult = HubUtil.checkService((BaseAccountsClient)accountsClientForCheck);
            if (checkResult.getStatus() == HubServiceCheckResult.Status.CANNOT_CHECK) {
                Throwable t = checkResult.getCause();
                throw new UpdaterHubServiceException(serviceIdInBundle, this.addExtraDetails(t, String.format("Cannot check existence of service for '%s' in Hub (%s): %s", serviceIdInBundle, this.bundleHubClient.getHubClient().getBaseUrl(), t.getMessage())), new HubServiceCheckResult(HubServiceCheckResult.Status.NOT_EXISTS, t));
            }
            Boolean exists = checkResult.exists();
            if (exists != null && !exists.booleanValue()) {
                boolean creationNeeded;
                boolean bl = creationNeeded = this.bundleHubClient.isInternalHub() || PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.oldHubProperties, serviceIdInBundle, "id") == null;
                if (creationNeeded) {
                    this.LOG.debug("Hub service for {} does not exist. Trying to create it...", (Object)serviceIdInBundle);
                    try {
                        ServiceClient clientForServiceCreation = this.getServiceClientForCreation();
                        String serviceLicenseName = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.newHubProperties, serviceIdInBundle, "license-user-name");
                        String serviceLicenseKey = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.newHubProperties, serviceIdInBundle, "license-key");
                        String serviceName = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.newHubProperties, serviceIdInBundle, "hub-service-name");
                        String serviceApplicationName = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.newHubProperties, serviceIdInBundle, "hub-service-application-name");
                        String serviceManufacturer = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.newHubProperties, serviceIdInBundle, "manufacturer");
                        String serviceVersion = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.newHubProperties, serviceIdInBundle, "version");
                        ServiceJSON serviceJSON = HubUtil.createEmptyVerifiedService((ServiceClient)clientForServiceCreation, (String)serviceIdInHub, (String)serviceSecret, (String)serviceName, (String)serviceLicenseName, (String)serviceLicenseKey, (String)serviceApplicationName, (String)serviceManufacturer, (String)serviceVersion, Collections.emptyList());
                        createdServices.add(serviceJSON.getId());
                        this.LOG.debug("Hub service for {} was created: {}", (Object)serviceIdInBundle, (Object)serviceIdInHub);
                    }
                    catch (Exception e) {
                        throw new UpdaterHubServiceException(serviceIdInBundle, this.addExtraDetails(e, String.format("Service for '%s' does not exists in Hub (%s). Attempt to create it failed: %s", serviceIdInBundle, this.bundleHubClient.getHubClient().getBaseUrl(), e.getMessage())), new HubServiceCheckResult(HubServiceCheckResult.Status.NOT_EXISTS, (Throwable)e));
                    }
                    checkResult = HubUtil.checkService((BaseAccountsClient)accountsClientForCheck);
                    if (checkResult.getStatus() == HubServiceCheckResult.Status.CANNOT_CHECK) {
                        Throwable t = checkResult.getCause();
                        throw new UpdaterHubServiceException(serviceIdInBundle, this.addExtraDetails(t, String.format("Cannot check existence of service for '%s' in Hub (%s) after creation: %s", serviceIdInBundle, this.bundleHubClient.getHubClient().getBaseUrl(), t.getMessage())), new HubServiceCheckResult(HubServiceCheckResult.Status.NOT_EXISTS, t));
                    }
                } else {
                    throw new UpdaterHubServiceException(serviceIdInBundle, String.format("Service for '%s' with id '%s' does not exists in External Hub (%s). Perhaps it was deleted manually?", serviceIdInBundle, serviceIdInHub, this.bundleHubClient.getHubClient().getBaseUrl()), new HubServiceCheckResult(HubServiceCheckResult.Status.NOT_EXISTS, null));
                }
            }
            if ((canBeUsed = checkResult.canBeUsed()) != null && !canBeUsed.booleanValue()) {
                switch (checkResult.getStatus()) {
                    case EXISTS_NOT_VERIFIED: 
                    case EXISTS_WRONG_SECRET: {
                        try {
                            this.LOG.debug("Hub service for '{}' not verified or have wrong secret. Trying to update it...", (Object)serviceIdInBundle);
                            ServiceClient clientForServiceUpdate = this.bundleHubClient.getBundleHubServiceClient();
                            this.updateSecretAndMakeVerifiedService(clientForServiceUpdate, serviceIdInBundle, serviceIdInHub, serviceSecret);
                            break;
                        }
                        catch (Exception e) {
                            throw new UpdaterHubServiceException(serviceIdInBundle, this.addExtraDetails(e, String.format("Service for '%s' not verified or have wrong secret in Hub (%s). Attempt to update it failed: %s", serviceIdInBundle, this.bundleHubClient.getHubClient().getBaseUrl(), e.getMessage())), new HubServiceCheckResult(checkResult.getStatus(), (Throwable)e));
                        }
                    }
                    case NOT_EXISTS: {
                        throw new UpdaterHubServiceException(serviceIdInBundle, String.format("Service for '%s' does not exists in Hub (%s)", serviceIdInBundle, this.bundleHubClient.getHubClient().getBaseUrl()), checkResult);
                    }
                    default: {
                        throw new UpdaterHubServiceException(serviceIdInBundle, String.format("Can not register or use service for '%s' in Hub (%s)", serviceIdInBundle, this.bundleHubClient.getHubClient().getBaseUrl()), checkResult);
                    }
                }
            }
            this.LOG.debug("Hub service for {} exists and verified: {}", (Object)serviceIdInBundle, (Object)serviceIdInHub);
        }
        return createdServices;
    }

    private String addExtraDetails(Throwable t, String message) {
        if (t instanceof WebApplicationException) {
            message = message + " Details: " + ErrorHelper.INSTANCE.readError((WebApplicationException)t).getMessage();
        }
        return message;
    }

    private void updateHubInfo(@NotNull Properties expectedHubProperties, boolean reset) {
        if (!this.bundleHubClient.isInternalHub()) {
            return;
        }
        BaseAccountsClient accountsClient = this.bundleHubClient.getBundleHubAccountsClient();
        this.rootGroupId = this.getRootGroupId(accountsClient);
        String hubServiceIdInHub = this.bundleHubClient.getHubClient().getOAuthClient().getHubScope();
        Map<ServiceParameter, String> changedServiceParameters = this.getHubChangedParameters(hubServiceIdInHub);
        this.compareAndUpdateParameters(expectedHubProperties, changedServiceParameters, hubServiceIdInHub, "hub", this.bundleHubClient.getBundleHubServiceClient(), reset);
    }

    private void updateGuestUserBanStatus(@NotNull Properties expectedHubProperties, boolean reset) {
        Boolean isGuestBanned;
        UserClient userClient;
        UserJSON guestUserInfo;
        boolean isCleanInstallationInProgress = PropertiesBasedConfigurationHelper.getHelper().isCleanInstallation((Object)this.newHubProperties);
        if ((reset || isCleanInstallationInProgress) && (guestUserInfo = (userClient = this.bundleHubClient.getBundleHubAccountsClient().getUserClient()).guest(null)) != null && guestUserInfo.getId() != null && (isGuestBanned = guestUserInfo.isBanned()) != null) {
            boolean valueDiffers;
            Boolean currentGuestUserIsAllowed = isGuestBanned == false;
            String newAllowAnonymousAccessString = this.newHubProperties.getProperty(BundleProperty.ALLOW_ANONYMOUS_ACCESS.getPrefixedName());
            Boolean newAllowAnonymousAccess = newAllowAnonymousAccessString == null || Boolean.valueOf(newAllowAnonymousAccessString) != false;
            boolean bl = valueDiffers = !Objects.equals(newAllowAnonymousAccess, currentGuestUserIsAllowed);
            if (valueDiffers) {
                guestUserInfo.setBanned(Boolean.valueOf(newAllowAnonymousAccess == false));
                userClient.updateUser(guestUserInfo.getId(), guestUserInfo);
            }
            expectedHubProperties.setProperty(BundleProperty.ALLOW_ANONYMOUS_ACCESS.getPrefixedName(), Boolean.toString(newAllowAnonymousAccess));
        }
    }

    private Map<ServiceParameter, String> getHubChangedParameters(String hubServiceIdInHub) {
        String oldHeaderVisibleGroupIds;
        HashMap<ServiceParameter, String> serviceParameters = new HashMap<ServiceParameter, String>();
        if (!this.bundleHubClient.isInternalHub()) {
            return Collections.emptyMap();
        }
        if (this.hubInIntegrationMode) {
            this.addParameterIfNotNull("hub", serviceParameters, "license-key", ServiceParameters.licenseKey);
            this.addParameterIfNotNull("hub", serviceParameters, "license-user-name", ServiceParameters.licenseUserName);
        }
        if (this.rootGroupId != null && (oldHeaderVisibleGroupIds = this.getOldHubConfigValue("hub", ServiceParameters.headerVisibleGroupIds.getName())) == null) {
            serviceParameters.put(ServiceParameters.headerVisibleGroupIds, this.rootGroupId);
        }
        if (!serviceParameters.isEmpty()) {
            serviceParameters.put(ServiceParameters.id, hubServiceIdInHub);
            return serviceParameters;
        }
        return Collections.emptyMap();
    }

    private void compareAndUpdateParameters(@NotNull Properties expectedHubProperties, Map<ServiceParameter, String> changedServiceParameters, String serviceIdInHub, String serviceIdInBundle, ServiceClient serviceClient, boolean reset) {
        if (!changedServiceParameters.isEmpty() && changedServiceParameters.containsKey(ServiceParameters.id)) {
            this.LOG.debug("Hub information for service {} ({}) changed in new configuration. Update may be needed", (Object)serviceIdInBundle, (Object)serviceIdInHub);
            boolean isCleanInstallationInProgress = PropertiesBasedConfigurationHelper.getHelper().isCleanInstallation((Object)this.newHubProperties);
            HashSet<Partial.Service> fieldsSet = new HashSet<Partial.Service>();
            for (ServiceParameter parameter : changedServiceParameters.keySet()) {
                fieldsSet.add(parameter.getPartial());
            }
            FieldPartial fields = new FieldPartial(fieldsSet);
            ServiceJSON currentServiceJSON = serviceClient.getService(serviceIdInHub, fields);
            ServiceJSON newServiceJSON = new ServiceJSON();
            newServiceJSON.setId(changedServiceParameters.get(ServiceParameters.id));
            boolean needToUpdate = false;
            for (ServiceParameter parameter : changedServiceParameters.keySet()) {
                String newValue = changedServiceParameters.get(parameter);
                String oldValue = this.getOldHubConfigValue(serviceIdInBundle, parameter.getName());
                String currentValue = parameter.getValueFromServiceJson(currentServiceJSON);
                if (ServiceParameters.redirectUris.equals(parameter)) {
                    needToUpdate |= this.updateRedirectUrisIfNeeded(currentServiceJSON, newServiceJSON, newValue, oldValue);
                } else {
                    boolean canUpdateProperty;
                    boolean changedInHub = !parameter.areEqualRawValues(oldValue, currentValue);
                    boolean overwriteHubValue = newValue != null && parameter.alwaysOverwriteHubValue();
                    boolean valueDiffers = !parameter.areEqualRawValues(newValue, currentValue);
                    boolean bl = canUpdateProperty = valueDiffers && (isCleanInstallationInProgress || reset || overwriteHubValue || !changedInHub);
                    if (valueDiffers && changedInHub && !canUpdateProperty) {
                        this.LOG.info("Property '{}' of service {} was changed on Hub to value '{}' (see service with id={}). Current configuration assumes it should be '{}', but will not overwrite current value.", new Object[]{parameter.getName(), serviceIdInBundle, this.getScreenedValue(parameter, currentValue), serviceIdInHub, this.getScreenedValue(parameter, newValue)});
                    }
                    if (canUpdateProperty || ServiceParameters.id.equals(parameter)) {
                        parameter.setValueToServiceJson(newServiceJSON, newValue);
                        needToUpdate = true;
                    }
                }
                expectedHubProperties.setProperty(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(serviceIdInBundle, parameter.getName()), newValue);
            }
            if (needToUpdate) {
                serviceClient.updateService(serviceIdInHub, newServiceJSON);
                this.LOG.debug("Hub information for service {} ({}) was updated: {}", new Object[]{serviceIdInBundle, serviceIdInHub, newServiceJSON});
            }
        }
    }

    @Nullable
    private String getScreenedValue(@NotNull ServiceParameter parameter, String value) {
        return ServiceParameters.licenseKey.equals(parameter) && value != null ? "*******" : value;
    }

    private boolean updateRedirectUrisIfNeeded(ServiceJSON currentServiceJSON, ServiceJSON newServiceJSON, String newValue, String oldValue) {
        boolean valueDiffers;
        Iterable currentIt = currentServiceJSON.getRedirectUris();
        HashSet currentRedirectUris = currentIt != null ? Sets.newHashSet((Iterable)currentIt) : new HashSet();
        Iterable<String> newValuesIt = ServiceParameters.redirectUris.restore(newValue);
        HashSet newRedirectUris = newValuesIt != null ? Sets.newHashSet(newValuesIt) : new HashSet();
        boolean bl = valueDiffers = !currentRedirectUris.containsAll(newRedirectUris);
        if (valueDiffers) {
            Iterable<String> oldValuesIt = ServiceParameters.redirectUris.restore(oldValue);
            HashSet oldValuesRedirectUris = oldValuesIt != null ? Sets.newHashSet(oldValuesIt) : new HashSet();
            HashSet resultedRedirectUris = new HashSet(currentRedirectUris);
            resultedRedirectUris.removeAll(oldValuesRedirectUris);
            resultedRedirectUris.addAll(newRedirectUris);
            newServiceJSON.setRedirectUris(resultedRedirectUris);
            return true;
        }
        return false;
    }

    private void updateServicesInfoInHub(@NotNull Properties expectedHubProperties, Set<String> createdServices, List<String> hubServices) {
        boolean reset = Boolean.valueOf(this.newHubProperties.getProperty("hub-reset"));
        this.LOG.debug("Force Hub update is set to: {}", (Object)reset);
        for (String serviceIdInBundle : hubServices) {
            this.LOG.debug("Check changes in Hub information for service {}", (Object)serviceIdInBundle);
            String serviceIdInHub = PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)this.newHubProperties, serviceIdInBundle, "hub-service-id");
            String serviceSecret = PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)this.newHubProperties, serviceIdInBundle, "hub-service-secret");
            HubClient hubClient = this.bundleHubClient.getHubClient();
            ServiceClient serviceClient = HubUtil.getServiceClientByIdAndSecret((HubClient)hubClient, (String)serviceIdInHub, (String)serviceSecret);
            if (this.rootGroupId == null) {
                this.rootGroupId = this.getRootGroupId(HubUtil.getAccountsClientByIdAndSecret((HubClient)hubClient, (String)serviceIdInHub, (String)serviceSecret));
            }
            Map<ServiceParameter, String> changedServiceParameters = this.getServiceChangedParameters(serviceIdInBundle);
            this.compareAndUpdateParameters(expectedHubProperties, changedServiceParameters, serviceIdInHub, serviceIdInBundle, serviceClient, reset || createdServices.contains(serviceIdInHub));
        }
    }

    private String getRootGroupId(BaseAccountsClient accountsClient) {
        UserGroupJSON groupJSON = accountsClient.getUserGroupClient().root(new FieldPartial((BaseField[])new Partial.UserGroup[]{Partial.UserGroup.ID}));
        if (groupJSON != null) {
            return groupJSON.getId();
        }
        return null;
    }

    private void updateSecretAndMakeVerifiedService(ServiceClient serviceClient, @NotNull String serviceIdInBundle, @NotNull String serviceIdInHub, @NotNull String serviceSecret) {
        ServiceJSON serviceJSON = new ServiceJSON();
        serviceJSON.setId(serviceIdInHub);
        serviceJSON.setSecret(serviceSecret);
        serviceJSON.setTrusted(Boolean.valueOf(true));
        serviceClient.updateService(serviceIdInHub, serviceJSON);
        this.LOG.debug("Hub service for '{}' updated: {}", (Object)serviceIdInBundle, (Object)serviceIdInHub);
    }

    @NotNull
    private static List<String> getHubServices(@NotNull Properties properties) {
        Collection services = PropertiesBasedConfigurationHelper.getHelper().getServices((Object)properties);
        ArrayList<String> hubServices = new ArrayList<String>();
        for (String serviceId : services) {
            if ("hub".equals(serviceId) || PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)properties, serviceId, "hub-service-id") == null) continue;
            hubServices.add(serviceId);
        }
        return hubServices;
    }

    @NotNull
    private Map<ServiceParameter, String> getServiceChangedParameters(String service) {
        String oldServiceName;
        String serviceBelongsTo = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.newHubProperties, service, "hub-service-belongs-to");
        if (serviceBelongsTo != null) {
            this.LOG.info("Not adding service {} since it belongs to another hub service {}", (Object)service, (Object)serviceBelongsTo);
            return Collections.emptyMap();
        }
        String newServiceIdInHub = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.newHubProperties, service, "hub-service-id");
        if (newServiceIdInHub == null) {
            this.LOG.info("Not adding service {} since its ID in Hub is not specified", (Object)service);
            return Collections.emptyMap();
        }
        String newServiceSecret = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.newHubProperties, service, "hub-service-secret");
        if (newServiceSecret == null) {
            this.LOG.info("Not adding service {} since its SECRET in Hub is not specified", (Object)service);
            return Collections.emptyMap();
        }
        HashMap<ServiceParameter, String> serviceParameters = new HashMap<ServiceParameter, String>();
        String newServiceUrl = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.newHubProperties, service, "base-url");
        if (newServiceUrl == null) {
            String oldServiceUrl = this.getOldHubConfigValue(service, ServiceParameters.homeUrl.getName());
            if (oldServiceUrl == null) {
                this.LOG.info("Not adding service {} since its BASE URL is not specified", (Object)service);
                return Collections.emptyMap();
            }
        } else {
            serviceParameters.put(ServiceParameters.homeUrl, newServiceUrl);
            List<String> redirectUris = HubServiceUpdater.getRedirectionUris(this.newHubProperties, service);
            serviceParameters.put(ServiceParameters.redirectUris, ServiceParameters.redirectUris.toRawValue(redirectUris));
        }
        String newServiceName = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.newHubProperties, service, "hub-service-name");
        if (newServiceName == null) {
            oldServiceName = this.getOldHubConfigValue(service, ServiceParameters.name.getName());
            if (oldServiceName == null) {
                this.LOG.info("Not adding service {} since its name is not specified", (Object)service);
                return Collections.emptyMap();
            }
        } else {
            serviceParameters.put(ServiceParameters.name, newServiceName);
        }
        this.addParameterIfNotNull(service, serviceParameters, "hub-service-application-name", ServiceParameters.applicationName);
        this.addParameterIfNotNull(service, serviceParameters, "manufacturer", ServiceParameters.applicationVendor);
        this.addParameterIfNotNull(service, serviceParameters, "version", ServiceParameters.applicationVersion);
        this.addParameterIfNotNull(service, serviceParameters, "license-key", ServiceParameters.licenseKey);
        this.addParameterIfNotNull(service, serviceParameters, "license-user-name", ServiceParameters.licenseUserName);
        if (this.rootGroupId != null && (oldServiceName = this.getOldHubConfigValue(service, ServiceParameters.headerVisibleGroupIds.getName())) == null) {
            serviceParameters.put(ServiceParameters.headerVisibleGroupIds, this.rootGroupId);
        }
        if (!serviceParameters.isEmpty()) {
            serviceParameters.put(ServiceParameters.id, newServiceIdInHub);
            return serviceParameters;
        }
        return Collections.emptyMap();
    }

    private void addParameterIfNotNull(String service, Map<ServiceParameter, String> serviceParameters, String propertyName, ServiceParameter<String> parameter) {
        String value = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)this.newHubProperties, service, propertyName);
        if (value != null) {
            serviceParameters.put(parameter, value);
        }
    }

    private String getOldHubConfigValue(String serviceId, String parameterName) {
        return this.oldHubProperties.getProperty(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(serviceId, parameterName));
    }

    private static List<String> getRedirectionUris(Properties properties, String service) {
        List<String> mainServiceRedirectUris = HubServiceUpdater.getRedirectUrisForService(properties, service);
        ArrayList<String> allRedirectUris = new ArrayList<String>(mainServiceRedirectUris);
        List<String> subServices = HubServiceUpdater.getSubServices(properties, service, PropertiesBasedConfigurationHelper.getHelper().getServices((Object)properties));
        for (String subService : subServices) {
            List<String> subServiceRedirectUris = HubServiceUpdater.getRedirectUrisForService(properties, subService);
            allRedirectUris.addAll(subServiceRedirectUris);
        }
        return allRedirectUris;
    }

    @NotNull
    private static List<String> getRedirectUrisForService(Properties properties, String service) {
        String serviceBaseUrl = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)properties, service, "base-url");
        if (serviceBaseUrl == null) {
            return Collections.emptyList();
        }
        ArrayList<String> redirectUris = new ArrayList<String>(HubServiceUpdater.getWithLocalHostSynonyms(serviceBaseUrl, properties));
        String serviceAdditionalRedirectUrisAsString = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)properties, service, "hub-additional-redirectUris");
        if (serviceAdditionalRedirectUrisAsString != null) {
            List<String> parsedRedirectUris = Arrays.asList(serviceAdditionalRedirectUrisAsString.split(" "));
            ArrayList<String> serviceAdditionalRedirectUris = new ArrayList<String>();
            for (String baseUri : redirectUris) {
                for (String serviceAdditionalUri : parsedRedirectUris) {
                    serviceAdditionalRedirectUris.add(UrlUtil.ensureEndsWithSlash((String)baseUri) + UrlUtil.ensureStartsWithoutSlash((String)serviceAdditionalUri));
                }
            }
            redirectUris.addAll(serviceAdditionalRedirectUris);
        }
        return redirectUris;
    }

    @NotNull
    private static List<String> getSubServices(@NotNull Properties properties, @NotNull String mainService, @NotNull Collection<String> allServices) {
        ArrayList<String> belongingServices = new ArrayList<String>();
        for (String service : allServices) {
            String serviceBelongsTo = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)properties, service, "hub-service-belongs-to");
            if (serviceBelongsTo == null || !serviceBelongsTo.equals(mainService)) continue;
            belongingServices.add(service);
        }
        return belongingServices;
    }

    @NotNull
    private static Collection<String> getWithLocalHostSynonyms(@NotNull String serviceUrl, @NotNull Properties properties) {
        return SystemUtil.getWithLocalHostSynonyms((String)serviceUrl, (Properties)properties, (boolean)true);
    }

    private ServiceClient getServiceClientForCreation() {
        if (this.bundleHubClient.isInternalHub()) {
            return HubUtil.getAnonymousHubServiceClient((HubClient)this.bundleHubClient.getHubClient());
        }
        return this.bundleHubClient.getBundleHubServiceClient();
    }
}

