/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.wizard;

import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.BundleProperties;
import com.jetbrains.bundle.BundleState;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.listener.OnePerClassListener;
import com.jetbrains.bundle.listener.event.StartFinishedEvent;
import com.jetbrains.bundle.util.BundleJvmOption;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardConfiguredProperties {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private volatile Properties myProperties;
    private final Path myPath;
    private final BundleEnvironment myBundleEnvironment;
    public static final String WIZARD_CONFIGURED_PROP_FILE = "wizard-configured.properties";
    public static final String PRODUCT_VERSIONS_CONFIGURED_BY_WIZARD = "configured.product.versions";

    public WizardConfiguredProperties(@NotNull BundleEnvironment bundleEnvironment) {
        this.myBundleEnvironment = bundleEnvironment;
        this.myPath = WizardConfiguredProperties.getConfigFilePath(this.myBundleEnvironment);
        if (Files.exists(this.myPath, new LinkOption[0])) {
            this.myProperties = ConfiguratorUtils.loadPropertiesFile((File)this.myPath.toFile());
        } else {
            this.LOG.debug(String.format("Wizard has not been run yet. The file [%s] does not exist", this.myPath));
            this.myProperties = null;
        }
    }

    public static Path getConfigFilePath(BundleEnvironment environment) {
        return environment.getInternalConfDir().resolve(WIZARD_CONFIGURED_PROP_FILE);
    }

    public boolean isConfigured(@NotNull BundleState bundleState) {
        return !this.shouldShowWizard(bundleState);
    }

    private boolean shouldShowWizard(@NotNull BundleState bundleState) {
        return (bundleState.getUpgradeProperties().isCleanInstallationInProgress() && this.shouldShowWizardOnCleanInstall(bundleState) || bundleState.getUpgradeProperties().isUpgrade() && this.shouldShowWizardOnUpgrade(bundleState)) && bundleState.getProperties().isServiceEnabled("configurationWizard");
    }

    private boolean shouldShowWizardOnCleanInstall(@NotNull BundleState bundleState) {
        return this.myProperties == null && Boolean.valueOf(BundleJvmOption.DISABLE_CONFIGURATION_WIZARD_ON_CLEAN_INSTALL.get()) == false;
    }

    private boolean shouldShowWizardOnUpgrade(@NotNull BundleState bundleState) {
        return !this.getConfiguredProductVersions().contains(bundleState.getBuildProperties().getProductFullVersionNumber()) && Boolean.valueOf(BundleJvmOption.DISABLE_CONFIGURATION_WIZARD_ON_UPGRADE.get()) == false;
    }

    @NotNull
    private List<String> getConfiguredProductVersions() {
        String value;
        List<String> configuredProductVersionsSet = Collections.emptyList();
        if (this.myProperties != null && (value = this.myProperties.getProperty(PRODUCT_VERSIONS_CONFIGURED_BY_WIZARD)) != null) {
            configuredProductVersionsSet = Arrays.asList(value.split(","));
        }
        return configuredProductVersionsSet;
    }

    public void registerConfiguredProductVersion(@NotNull BundleState bundleState) {
        if (this.myProperties != null) {
            String productFullVersion = bundleState.getBuildProperties().getProductFullVersionNumber();
            String value = this.myProperties.getProperty(PRODUCT_VERSIONS_CONFIGURED_BY_WIZARD);
            if (value == null) {
                this.myProperties.setProperty(PRODUCT_VERSIONS_CONFIGURED_BY_WIZARD, productFullVersion);
            } else {
                this.myProperties.setProperty(PRODUCT_VERSIONS_CONFIGURED_BY_WIZARD, value + "," + productFullVersion);
            }
            this.saveConfig();
        }
    }

    private static void saveConfig(@NotNull File configPath, @NotNull Properties properties) {
        ConfiguratorUtils.savePropertiesFile((File)configPath, (Properties)properties, (String)"Wizard configured properties overriding product defaults.");
    }

    private void saveConfig() {
        WizardConfiguredProperties.saveConfig(this.myPath.toFile(), this.myProperties);
    }

    private static void checkServices(@NotNull Collection<ServiceDescriptor> allServices) {
        for (ServiceDescriptor descriptor : allServices) {
            if (!"configurationWizard".equals(descriptor.getId())) continue;
            throw new RuntimeException("Actual Bundle services should have been passed, Configuration Wizard can not be among those");
        }
    }

    public boolean reloadProperties() {
        if (!Files.exists(this.myPath, new LinkOption[0])) {
            this.LOG.debug(String.format("Can not reload Wizard properties: file [%s] doesn't exist", this.myPath));
            return false;
        }
        this.LOG.debug(String.format("Reloading properties from existing file [%s]", this.myPath));
        Properties tmpProperties = ConfiguratorUtils.loadPropertiesFile((File)this.myPath.toFile());
        this.LOG.debug(String.format("There are %s properties found", tmpProperties.size()));
        for (String propName : tmpProperties.stringPropertyNames()) {
            this.LOG.debug(String.format("Loaded property [%s]", propName));
        }
        boolean isDirty = this.processProperties(tmpProperties);
        if (isDirty) {
            WizardConfiguredProperties.saveConfig(this.myPath.toFile(), tmpProperties);
        }
        this.myProperties = tmpProperties;
        return true;
    }

    private boolean processProperties(@NotNull Properties properties) {
        boolean isDirty = false;
        for (String propertyName : properties.stringPropertyNames()) {
            String adaptedValue;
            String value = properties.getProperty(propertyName);
            if (value.equals(adaptedValue = BundleProperties.getPropertyValueInInternalFormat(propertyName, value, this.myBundleEnvironment))) continue;
            properties.setProperty(propertyName, adaptedValue);
            isDirty = true;
        }
        return isDirty;
    }

    @Nullable
    String getPropertyValueInExternalFormat(@NotNull String propertyName) {
        String propertyValue = this.myProperties.getProperty(propertyName);
        return BundleProperties.getPropertyValueInExternalFormat(propertyName, propertyValue, this.myBundleEnvironment);
    }

    public Properties getProperties() {
        return this.myProperties;
    }

    public boolean exists() {
        return this.myProperties != null;
    }

    public Path getPath() {
        return this.myPath;
    }

    public void removeProperties(@NotNull Collection<String> propertyNames) {
        if (propertyNames.isEmpty() || !this.exists()) {
            return;
        }
        boolean isDirty = false;
        for (String propName : propertyNames) {
            Object removedValue = this.myProperties.remove(propName);
            isDirty |= removedValue != null;
        }
        if (isDirty) {
            WizardConfiguredProperties.saveConfig(this.myPath.toFile(), this.myProperties);
        }
    }

    public static class BundleStartFinishedListener
    extends OnePerClassListener<StartFinishedEvent> {
        @Override
        public void onSuccess(@NotNull StartFinishedEvent event) {
            WizardConfiguredProperties properties = new WizardConfiguredProperties(event.getBundleState().getEnvironment());
            if (properties.exists()) {
                properties.removeProperties(Arrays.asList("wizard-url", "wizard-actual-client-url"));
                Map serviceToLicenseKey = PropertiesBasedConfigurationHelper.getHelper().getServicesPropertyValue((Object)properties.getProperties(), "license-key");
                serviceToLicenseKey.forEach((key, value) -> properties.removeProperties(Arrays.asList(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(key, "license-key"), PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(key, "license-user-name"))));
            }
        }

        @Override
        public void onFailure(@NotNull StartFinishedEvent event, @NotNull Throwable t) {
        }
    }
}

