/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.wizard;

import com.jetbrains.bundle.PropertiesProvider;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.wizard.WizardConfiguredProperties;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class WizardPropertiesProvider
implements PropertiesProvider {
    List<ServiceDescriptor> myAllServices;
    WizardConfiguredProperties myWizardConfiguredProperties;

    public WizardPropertiesProvider(WizardConfiguredProperties wizardConfiguredProperties, List<ServiceDescriptor> allServices) {
        this.myAllServices = allServices;
        this.myWizardConfiguredProperties = wizardConfiguredProperties;
    }

    @Override
    public void addToServiceProperties(@NotNull ServiceDescriptor descriptor, @NotNull Properties serviceProperties) {
        if (this.myWizardConfiguredProperties.exists()) {
            String servicePrefix = PropertiesBasedConfigurationHelper.getHelper().constructServicePrefix(descriptor.getId());
            for (String wizardPropertyName : this.myWizardConfiguredProperties.getProperties().stringPropertyNames()) {
                if (PropertiesBasedConfigurationHelper.getHelper().parseServiceIdPrefix(wizardPropertyName) != null) {
                    String servicePropertyName = wizardPropertyName.startsWith(servicePrefix) ? wizardPropertyName.substring(servicePrefix.length()) : wizardPropertyName;
                    serviceProperties.setProperty(servicePropertyName, this.myWizardConfiguredProperties.getPropertyValueInExternalFormat(wizardPropertyName));
                    continue;
                }
                if (!descriptor.isInternal()) continue;
                serviceProperties.setProperty(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName("configurationWizard", wizardPropertyName), this.myWizardConfiguredProperties.getPropertyValueInExternalFormat(wizardPropertyName));
            }
        }
    }
}

