/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.bundle.InstallationConfiguration;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;

public class BundleEnvironment {
    public static final String INTERNAL_FOLDER_NAME = "internal";
    private static final String CONF_FOLDER_NAME = "conf";
    public static final String BUNDLE_CONFIG_FILE_NAME = "bundle.properties";
    public static final String HUB_CONFIG_FILE_NAME = "hub.properties";
    public static final String UPGRADE_PROPERTIES = "upgrade.properties";
    public static final String WIZARD_CONFIGURED_PROPERTIES_FILE_NAME = "wizard-configured.properties";
    private static final String BUNDLE_BUILD_CONFIG_FILE_NAME = "bundle_build.properties";
    private static final String ADDITIONAL_KEYSTORE_FILE_NAME = "keystore.jks";
    public static final String UPLOAD_KEYSTORE_FILE_NAME = "keystore.jks";
    static final String UPLOAD_PRIVATE_KEY_FILE_NAME = "privateKey.pem";
    static final String UPLOAD_CERTIFICATE_FILE_NAME = "certificate.crt";
    static final String UPLOAD_CERTIFICATE_CHAIN_FILE_NAME = "certificateChain.crt";
    private final Path myBundleHome;
    private final InstallationConfiguration myInstallationConfig;

    public BundleEnvironment(Path bundleHome) {
        this.myBundleHome = bundleHome;
        this.myInstallationConfig = new InstallationConfiguration(this.getBundleInstallationConfig());
    }

    @NotNull
    public Path getBundleHome() {
        return this.myBundleHome;
    }

    @NotNull
    public Path getApplicationDataRootDirectory() {
        Path path;
        String predefinedAppDataRootDirectory = this.myInstallationConfig.getApplicationDataRootDirectory();
        Path appDataRoot = predefinedAppDataRootDirectory != null && !predefinedAppDataRootDirectory.trim().isEmpty() ? ((path = Paths.get(predefinedAppDataRootDirectory, new String[0])).isAbsolute() ? path : this.getBundleHome().resolve(path.normalize())) : this.getBundleHome();
        return appDataRoot;
    }

    @NotNull
    public Path getBundleConfig() {
        return this.getInternalConfDir().resolve(BUNDLE_CONFIG_FILE_NAME);
    }

    @NotNull
    public Path getUpgradePropertiesFile() {
        return this.getInternalConfDir().resolve(UPGRADE_PROPERTIES);
    }

    @NotNull
    Path getAdditionalKeystorePath() {
        return this.getConfDir().resolve(BundleEnvironment.getAdditionalKeystoreRelativePath()).toAbsolutePath();
    }

    @NotNull
    public static Path getAdditionalKeystoreRelativePath() {
        return Paths.get(INTERNAL_FOLDER_NAME, "keystore.jks");
    }

    @NotNull
    public Path getWizardConfiguredPropertiesFile() {
        return this.getInternalConfDir().resolve(WIZARD_CONFIGURED_PROPERTIES_FILE_NAME);
    }

    @NotNull
    public Path getBundleBuildConfig() {
        return this.getBundleHomeInternal().resolve(CONF_FOLDER_NAME).resolve(BUNDLE_BUILD_CONFIG_FILE_NAME);
    }

    @NotNull
    public Path getInternalConfDir() {
        return this.getConfDir().resolve(INTERNAL_FOLDER_NAME);
    }

    @NotNull
    private Path getInternalServicesConfDir() {
        return this.getInternalServicesDir(this.getConfDir());
    }

    @NotNull
    public Path getInternalServicesDir(@NotNull Path rootDir) {
        return rootDir.resolve(INTERNAL_FOLDER_NAME).resolve("services");
    }

    @NotNull
    public Path getConfDir() {
        String confLocationFromInstallationXml = this.myInstallationConfig.getConfLocation();
        if (confLocationFromInstallationXml == null) {
            return this.getApplicationDataRootDirectory().resolve(CONF_FOLDER_NAME);
        }
        Path confLocation = Paths.get(confLocationFromInstallationXml, new String[0]);
        if (confLocation.isAbsolute()) {
            return confLocation;
        }
        return this.getApplicationDataRootDirectory().resolve(confLocation);
    }

    @NotNull
    public Path getBundleHomeInternal() {
        return this.myBundleHome.resolve(INTERNAL_FOLDER_NAME);
    }

    @NotNull
    public InstallationConfiguration getInstallationConfig() {
        return this.myInstallationConfig;
    }

    @NotNull
    public Path getBundleInstallationConfig() {
        return this.getBundleHomeInternal().resolve(CONF_FOLDER_NAME).resolve("installation.xml");
    }

    @NotNull
    Path getUploadServerCertPath() {
        return this.getConfDir().resolve(BundleEnvironment.getUploadServerCertRelativePath());
    }

    @NotNull
    private static Path getUploadServerCertRelativePath() {
        return Paths.get(INTERNAL_FOLDER_NAME, new String[0]).resolve("cert");
    }

    @NotNull
    private static Path getUploadPrivateKeyAndCertRelativePath() {
        return BundleEnvironment.getUploadServerCertRelativePath().resolve("privateKeyAndCert");
    }

    @NotNull
    Path getUploadKeyStorePath() {
        return BundleEnvironment.getUploadKeyStorePath(this.getConfDir());
    }

    @NotNull
    public static Path getUploadKeyStorePath(@NotNull Path confFolder) {
        return confFolder.resolve(BundleEnvironment.getUploadServerCertRelativePath()).resolve("keystore").resolve("keystore.jks").toAbsolutePath();
    }

    @NotNull
    Path getUploadPrivateKeyPath() {
        return BundleEnvironment.getUploadPrivateKeyPath(this.getConfDir());
    }

    @NotNull
    public static Path getUploadPrivateKeyPath(@NotNull Path confFolder) {
        return confFolder.resolve(BundleEnvironment.getUploadPrivateKeyAndCertRelativePath()).resolve(UPLOAD_PRIVATE_KEY_FILE_NAME).toAbsolutePath();
    }

    @NotNull
    Path getUploadCertificatePath() {
        return BundleEnvironment.getUploadCertificatePath(this.getConfDir());
    }

    @NotNull
    public static Path getUploadCertificatePath(@NotNull Path confFolder) {
        return confFolder.resolve(BundleEnvironment.getUploadPrivateKeyAndCertRelativePath()).resolve(UPLOAD_CERTIFICATE_FILE_NAME).toAbsolutePath();
    }

    @NotNull
    Path getUploadCertificateChainPath() {
        return BundleEnvironment.getUploadCertificateChainPath(this.getConfDir());
    }

    @NotNull
    public static Path getUploadCertificateChainPath(@NotNull Path confFolder) {
        return confFolder.resolve(BundleEnvironment.getUploadPrivateKeyAndCertRelativePath()).resolve(UPLOAD_CERTIFICATE_CHAIN_FILE_NAME).toAbsolutePath();
    }

    @NotNull
    public File getInternalServiceConfDir(String serviceId) {
        return this.getInternalServicesConfDir().resolve(serviceId).toFile();
    }

    @NotNull
    public File getDistConfigs() {
        return this.getBundleHomeInternal().resolve(CONF_FOLDER_NAME).resolve("dist_configs.zip").toFile();
    }
}

