/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.util.auth.impl;

import com.jetbrains.bundle.api.internal.auth.AuthResult;
import com.jetbrains.bundle.api.internal.auth.AuthService;
import com.jetbrains.bundle.util.auth.exceptions.AuthenticationException;
import com.jetbrains.bundle.util.auth.exceptions.TooManyFailedAuthAttemptsException;
import com.jetbrains.bundle.util.auth.impl.SimpleAuthenticator;
import org.jetbrains.annotations.NotNull;

public class AuthenticatorCountingAttemptsImpl
extends SimpleAuthenticator {
    private static final int MAXIMUM_FAILED_ATTEMPTS_COUNT = 5;
    private static final long INTERVAL_AFTER_FAILED_ATTEMPTS_IN_MILLIS = 300000L;
    private int failedAttemptsCount;
    private long lastAttemptFailureMillis;
    private final Object monitor = new Object();

    public AuthenticatorCountingAttemptsImpl(@NotNull AuthService bundleFacade) {
        super(bundleFacade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authenticate(String awcToken) throws AuthenticationException, TooManyFailedAuthAttemptsException {
        if (awcToken == null || awcToken.trim().isEmpty()) {
            AuthResult authResult = this.getAuthService().authenticate("");
            throw new AuthenticationException(authResult.getTokenStorage());
        }
        Object authResult = this.monitor;
        synchronized (authResult) {
            if (this.failedAttemptsCount >= 5) {
                long passedSinceLastFailure = System.currentTimeMillis() - this.lastAttemptFailureMillis;
                if (passedSinceLastFailure < 300000L) {
                    AuthResult authResult2 = this.getAuthService().authenticate(awcToken);
                    throw new TooManyFailedAuthAttemptsException(300000L - passedSinceLastFailure, 5, authResult2.getTokenStorage());
                }
                this.failedAttemptsCount = 0;
            }
        }
        authResult = this.getAuthService().authenticate(awcToken);
        Object object = this.monitor;
        synchronized (object) {
            if (!authResult.isSuccessful()) {
                ++this.failedAttemptsCount;
                this.lastAttemptFailureMillis = System.currentTimeMillis();
                throw new AuthenticationException(authResult.getTokenStorage());
            }
            this.failedAttemptsCount = 0;
            this.lastAttemptFailureMillis = -1L;
        }
    }
}

