/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.util.tls;

import com.jetbrains.bundle.util.tls.KeyStoreGenerationException;
import com.jetbrains.bundle.util.tls.PemPrivateKeyLoader;
import com.jetbrains.service.util.ssl.KeystoreUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyStoreGenerator {
    private static final String KEYSTORE_TYPE_JKS = "JKS";
    public static final String CERTIFICATE_FORMAT = "X.509";

    public static KeyStore generate(@NotNull Path keyStorePath, @NotNull String keyStorePassword, @NotNull String keyStoreAlias, @NotNull Path privateKeyPath, @Nullable String privateKeyPassphrase, @NotNull Path certificatePath, @Nullable Path certificateChainPath, boolean save) throws KeyStoreGenerationException {
        return KeyStoreGenerator.generate(keyStorePath, keyStorePassword, keyStoreAlias, new PemPrivateKeyLoader(privateKeyPath, privateKeyPassphrase), new PathCertificateLoader(certificatePath), new PathCertificateLoader(certificateChainPath), save);
    }

    public static KeyStore generate(@NotNull Path keyStorePath, @NotNull String keyStorePassword, @NotNull String keyStoreAlias, byte[] privateKey, @Nullable String privateKeyPassphrase, @NotNull byte[] certificate, @Nullable byte[] certificateChain) throws KeyStoreGenerationException {
        return KeyStoreGenerator.generate(keyStorePath, keyStorePassword, keyStoreAlias, new PemPrivateKeyLoader(privateKey, privateKeyPassphrase), new ByteArrayCertificateLoader(certificate), new ByteArrayCertificateLoader(certificateChain), false);
    }

    public static KeyStore generate(@NotNull Path keyStorePath, @NotNull String keyStorePassword, @NotNull String keyStoreAlias, PemPrivateKeyLoader privateKeyLoader, @NotNull CertificateLoader certificateLoader, @NotNull CertificateLoader certificateChainLoader, boolean save) throws KeyStoreGenerationException {
        try {
            PrivateKey privateKey = privateKeyLoader.load();
            if (privateKey == null) {
                throw new Exception("The private key is invalid");
            }
            KeyStore keyStore = KeyStoreGenerator.loadKeyStore(keyStorePath, keyStorePassword);
            X509Certificate cert = certificateLoader.load();
            if (cert == null) {
                throw new Exception("Certificate does not exist");
            }
            X509Certificate certChain = certificateChainLoader.load();
            if (certChain != null) {
                keyStore.setKeyEntry(keyStoreAlias, privateKey, keyStorePassword.toCharArray(), new Certificate[]{cert, certChain});
            } else {
                keyStore.setKeyEntry(keyStoreAlias, privateKey, keyStorePassword.toCharArray(), new Certificate[]{cert});
            }
            if (save) {
                KeystoreUtil.saveKeyStore((KeyStore)keyStore, (String)keyStorePath.toString(), (String)keyStorePassword);
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new KeyStoreGenerationException("Key store generation error", e);
        }
    }

    @NotNull
    static KeyStore loadKeyStore(@NotNull Path keyStorePath, @NotNull String keyStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE_JKS);
        if (Files.notExists(keyStorePath, new LinkOption[0])) {
            keyStore.load(null, null);
        } else {
            try (FileInputStream keyStoreInputStream = new FileInputStream(keyStorePath.toFile());){
                keyStore.load(keyStoreInputStream, keyStorePassword.toCharArray());
            }
        }
        return keyStore;
    }

    static final class ByteArrayCertificateLoader
    extends CertificateLoader {
        private final byte[] certificateBytes;

        ByteArrayCertificateLoader(@Nullable byte[] certificateBytes) {
            this.certificateBytes = certificateBytes;
        }

        @Override
        @Nullable
        X509Certificate load() throws CertificateException, IOException {
            if (this.certificateBytes == null) {
                return null;
            }
            try (ByteArrayInputStream is = new ByteArrayInputStream(this.certificateBytes);){
                X509Certificate x509Certificate = this.load(is);
                return x509Certificate;
            }
        }
    }

    static final class PathCertificateLoader
    extends CertificateLoader {
        private final Path path;

        PathCertificateLoader(@Nullable Path path) {
            this.path = path;
        }

        @Override
        @Nullable
        X509Certificate load() throws CertificateException, IOException {
            if (this.path == null || !Files.exists(this.path, new LinkOption[0])) {
                return null;
            }
            try (FileInputStream is = new FileInputStream(this.path.toFile());){
                X509Certificate x509Certificate = this.load(is);
                return x509Certificate;
            }
        }
    }

    private static abstract class CertificateLoader {
        private CertificateLoader() {
        }

        @Nullable
        abstract X509Certificate load() throws CertificateException, IOException;

        @Nullable
        final X509Certificate load(@NotNull InputStream certificateAsStream) throws CertificateException {
            CertificateFactory fact = CertificateFactory.getInstance(KeyStoreGenerator.CERTIFICATE_FORMAT);
            return (X509Certificate)fact.generateCertificate(certificateAsStream);
        }
    }
}

