/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.util.tls;

import com.jetbrains.bundle.util.tls.PrivateKeyDecryptionException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PemPrivateKeyLoader {
    private final byte[] privateKeyBytes;
    private final String passphrase;
    private final Path file;

    public PemPrivateKeyLoader(@NotNull byte[] privateKeyBytes, @Nullable String passphrase) {
        this.file = null;
        this.privateKeyBytes = privateKeyBytes;
        this.passphrase = passphrase;
    }

    PemPrivateKeyLoader(@NotNull Path file, String passphrase) {
        this.file = file;
        this.privateKeyBytes = null;
        this.passphrase = passphrase;
    }

    @Nullable
    public PrivateKey load() throws IOException, PrivateKeyDecryptionException {
        try {
            Object parsedPemObject;
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            if ((parsedPemObject = this.parsePemObject()) == null) {
                PrivateKey privateKey = null;
                return privateKey;
            }
            PrivateKey privateKey = this.getPrivateKey(parsedPemObject);
            return privateKey;
        }
        finally {
            Security.removeProvider("BC");
        }
    }

    @Nullable
    private Object parsePemObject() throws IOException {
        Object parsedPemObject;
        block39: {
            if (this.privateKeyBytes != null) {
                try (ByteArrayInputStream privateKeyInputStream = new ByteArrayInputStream(this.privateKeyBytes);
                     InputStreamReader privateKeyInputStreamReader = new InputStreamReader(privateKeyInputStream);){
                    parsedPemObject = new PEMParser((Reader)privateKeyInputStreamReader).readObject();
                    break block39;
                }
            }
            if (this.file != null) {
                try (InputStreamReader inputStreamReader = new InputStreamReader(Files.newInputStream(this.file, new OpenOption[0]));){
                    parsedPemObject = new PEMParser((Reader)inputStreamReader).readObject();
                }
            } else {
                throw new IllegalStateException("Either file path or private key bytes should has been passed to PemPrivateKeyLoader");
            }
        }
        return parsedPemObject;
    }

    @Nullable
    private PrivateKey getPrivateKey(Object parsedPemObject) throws IOException, PrivateKeyDecryptionException {
        PrivateKey privateKey;
        if (parsedPemObject == null) {
            return null;
        }
        JcaPEMKeyConverter pemKeyConverter = new JcaPEMKeyConverter();
        if (parsedPemObject instanceof PEMEncryptedKeyPair) {
            PEMKeyPair pemKeyPair;
            try {
                pemKeyPair = ((PEMEncryptedKeyPair)parsedPemObject).decryptKeyPair(new JcePEMDecryptorProviderBuilder().build(this.passphrase != null ? this.passphrase.toCharArray() : "".toCharArray()));
            }
            catch (IOException e) {
                throw new PrivateKeyDecryptionException(e);
            }
            privateKey = pemKeyConverter.getKeyPair(pemKeyPair).getPrivate();
        } else if (parsedPemObject instanceof PEMKeyPair) {
            privateKey = pemKeyConverter.getKeyPair((PEMKeyPair)parsedPemObject).getPrivate();
        } else if (parsedPemObject instanceof PKCS8EncryptedPrivateKeyInfo) {
            PrivateKeyInfo pemPrivateKeyInfo;
            try {
                pemPrivateKeyInfo = ((PKCS8EncryptedPrivateKeyInfo)parsedPemObject).decryptPrivateKeyInfo(new JceOpenSSLPKCS8DecryptorProviderBuilder().build(this.passphrase != null ? this.passphrase.toCharArray() : "".toCharArray()));
            }
            catch (OperatorCreationException | PKCSException e) {
                throw new PrivateKeyDecryptionException(e);
            }
            privateKey = pemKeyConverter.getPrivateKey(pemPrivateKeyInfo);
        } else if (parsedPemObject instanceof PrivateKeyInfo) {
            privateKey = pemKeyConverter.getPrivateKey((PrivateKeyInfo)parsedPemObject);
        } else {
            throw new IllegalStateException("Unsupported private Key format: " + parsedPemObject.getClass().getSimpleName());
        }
        return privateKey;
    }
}

